/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerGrave
extends AbstractContainerMenu {
    private final IItemHandler inventory;
    public final AbstractTileEntityGrave grave;
    private final int inventorySize;

    public static ContainerGrave fromFriendlyByteBuf(int windowId, Inventory inv, FriendlyByteBuf packetBuffer) {
        return new ContainerGrave(windowId, inv, packetBuffer);
    }

    public ContainerGrave(int windowId, Inventory inv, FriendlyByteBuf extra) {
        super((MenuType)ModContainers.graveInv.get(), windowId);
        int i;
        BlockPos grave = extra.m_130135_();
        AbstractTileEntityGrave abstractTileEntityGrave = (AbstractTileEntityGrave)inv.f_35978_.f_19853_.m_7702_(grave);
        this.inventory = abstractTileEntityGrave.getInventory();
        this.grave = abstractTileEntityGrave;
        this.inventorySize = this.inventory.getSlots() / 9;
        int size = this.inventory.getSlots();
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.m_38897_((Slot)new SlotItemHandler(this.inventory, index, 8 + k * 18, 18 + j * 18));
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player playerIn, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.m_7993_().m_41777_();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.m_38903_(stackCopy, maxIndex, this.f_38839_.size(), true) : !this.m_38903_(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.m_5852_(ItemStackUtils.EMPTY);
        } else {
            slot.m_5852_(stackCopy);
            slot.m_6654_();
        }
        return stackCopy;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack before = stack.m_41777_();
        boolean merge = super.m_38903_(stack, startIndex, endIndex, reverseDirection);
        return merge;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }
}

