/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.loot.ModLootConditions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchUnlocked
implements LootItemCondition {
    private final ResourceLocation effectId;
    private final double minStrength;
    private final double maxStrength;

    private ResearchUnlocked(@NotNull ResourceLocation effectId, double minStrength, double maxStrength) {
        this.effectId = effectId;
        this.minStrength = minStrength;
        this.maxStrength = maxStrength;
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId) {
        return ResearchUnlocked.effect(effectId, Double.MIN_VALUE);
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId, double strength) {
        return ResearchUnlocked.effect(effectId, strength, Double.MAX_VALUE);
    }

    public static LootItemCondition.Builder effect(@NotNull ResourceLocation effectId, double minStrength, double maxStrength) {
        return () -> new ResearchUnlocked(effectId, minStrength, maxStrength);
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return ModLootConditions.researchUnlocked;
    }

    public boolean test(@NotNull LootContext lootContext) {
        return this.test(lootContext, (Entity)lootContext.m_78953_(LootContextParams.f_81458_)).or(() -> this.test(lootContext, (Entity)lootContext.m_78953_(LootContextParams.f_81455_))).or(() -> this.test(lootContext, (Vec3)lootContext.m_78953_(LootContextParams.f_81460_))).orElse(false);
    }

    private Optional<Boolean> test(@NotNull LootContext lootContext, @Nullable Entity entity) {
        return Optional.ofNullable(entity).map(e -> {
            AbstractEntityCitizen citizen;
            return e instanceof AbstractEntityCitizen ? (citizen = (AbstractEntityCitizen)e) : null;
        }).flatMap(c -> this.test(lootContext, c.getCitizenColonyHandler().getColony()));
    }

    private Optional<Boolean> test(@NotNull LootContext lootContext, @Nullable Vec3 origin) {
        return Optional.ofNullable(origin).map(BlockPos::new).flatMap(pos -> this.test(lootContext, IColonyManager.getInstance().getIColony((Level)lootContext.m_78952_(), (BlockPos)pos)));
    }

    private Optional<Boolean> test(@NotNull LootContext lootContext, @Nullable IColony colony) {
        return Optional.ofNullable(colony).map(c -> c.getResearchManager().getResearchEffects().getEffectStrength(this.effectId)).map(s -> s >= this.minStrength && s < this.maxStrength);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ResearchUnlocked> {
        public void serialize(@NotNull JsonObject json, @NotNull ResearchUnlocked condition, @NotNull JsonSerializationContext context) {
            json.addProperty("id", condition.effectId.toString());
            if (condition.minStrength != Double.MIN_VALUE) {
                json.addProperty("minStrength", (Number)condition.minStrength);
            }
            if (condition.maxStrength != Double.MAX_VALUE) {
                json.addProperty("maxStrength", (Number)condition.maxStrength);
            }
        }

        @NotNull
        public ResearchUnlocked deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            ResourceLocation researchId = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"id", (String)""));
            double minStrength = GsonHelper.m_144742_((JsonObject)json, (String)"minStrength", (double)Double.MIN_VALUE);
            double maxStrength = GsonHelper.m_144742_((JsonObject)json, (String)"maxStrength", (double)Double.MAX_VALUE);
            return new ResearchUnlocked(researchId, minStrength, maxStrength);
        }
    }
}

