/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.colony.buildings.IBuilding;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class WorldUtil {
    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.m_7726_() instanceof ServerChunkCache) {
            ChunkHolder holder = (ChunkHolder)((ServerChunkCache)world.m_7726_()).f_8325_.f_140130_.get(ChunkPos.m_45589_((int)x, (int)z));
            if (holder != null) {
                return holder.m_140082_().getNow(ChunkHolder.f_139997_).left().isPresent();
            }
            return false;
        }
        return world.m_6522_(x, z, ChunkStatus.f_62326_, false) != null;
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        if (WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            world.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_8092_(true);
            BlockState state = world.m_8055_(pos);
            world.m_7260_(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.f_45578_, pos.f_45579_);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return WorldUtil.isChunkLoaded(world, pos) && ((ServerLevel)world).m_143340_(pos.m_45615_());
        }
        return WorldUtil.isChunkLoaded(world, pos);
    }

    public static boolean isAABBLoaded(Level world, AABB box) {
        return WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.f_82288_ >> 4, (int)box.f_82290_ >> 4) && WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.f_82291_ >> 4, (int)box.f_82293_ >> 4);
    }

    public static boolean isDayTime(Level world) {
        return world.m_46468_() % 24000L <= 12600L;
    }

    public static boolean isPastTime(Level world, int pastTime) {
        return world.m_46468_() % 24000L <= (long)pastTime;
    }

    public static boolean isPastNoon(Level world) {
        return WorldUtil.isPastTime(world, 6000);
    }

    public static boolean isOverworldType(@NotNull Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223538_);
    }

    public static boolean isNetherType(@NotNull Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223539_);
    }

    public static boolean isOfWorldType(@NotNull Level world, @NotNull ResourceKey<DimensionType> type) {
        RegistryAccess dynRegistries = world.m_5962_();
        ResourceLocation loc = ((Registry)dynRegistries.m_6632_(Registry.f_122818_).get()).m_7981_((Object)world.m_6042_());
        if (loc == null) {
            if (world.f_46443_) {
                return world.m_6042_().f_63837_().equals((Object)type.m_135782_());
            }
            return false;
        }
        ResourceKey regKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(@NotNull Level world) {
        return !world.m_6106_().m_5470_().m_46207_(GameRules.f_46134_) || world.m_46791_().equals((Object)Difficulty.PEACEFUL);
    }

    public static boolean setBlockState(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.m_5776_()) {
            return world.m_7731_(pos, state, 3);
        }
        return WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static boolean setBlockState(LevelAccessor world, BlockPos pos, BlockState state, int flags) {
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return world.m_7731_(pos, state, flags);
        }
        if ((flags & 2) != 0) {
            Set navigators = ((ServerLevel)world).f_143246_;
            ((ServerLevel)world).f_143246_.clear();
            boolean result = world.m_7731_(pos, state, flags);
            ((ServerLevel)world).f_143246_.addAll(navigators);
            return result;
        }
        return world.m_7731_(pos, state, flags);
    }

    public static boolean removeBlock(LevelAccessor world, BlockPos pos, boolean isMoving) {
        FluidState fluidstate = world.m_6425_(pos);
        return WorldUtil.setBlockState(world, pos, fluidstate.m_76188_(), 3 | (isMoving ? 64 : 0));
    }

    public static <T extends Entity> List<? extends T> getEntitiesWithinBuilding(@NotNull Level world, @NotNull Class<? extends T> clazz, @NotNull IBuilding building, @Nullable Predicate<? super T> predicate) {
        Tuple<BlockPos, BlockPos> corners = building.getCorners();
        if (predicate == null) {
            return world.m_45976_(clazz, new AABB((double)((BlockPos)corners.m_14418_()).m_123341_(), (double)((BlockPos)corners.m_14418_()).m_123342_(), (double)((BlockPos)corners.m_14418_()).m_123343_(), (double)((BlockPos)corners.m_14419_()).m_123341_(), (double)((BlockPos)corners.m_14419_()).m_123342_(), (double)((BlockPos)corners.m_14419_()).m_123343_()));
        }
        return world.m_6443_(clazz, new AABB((double)((BlockPos)corners.m_14418_()).m_123341_(), (double)((BlockPos)corners.m_14418_()).m_123342_(), (double)((BlockPos)corners.m_14418_()).m_123343_(), (double)((BlockPos)corners.m_14419_()).m_123341_(), (double)((BlockPos)corners.m_14419_()).m_123342_(), (double)((BlockPos)corners.m_14419_()).m_123343_()), predicate);
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.f_63865_() + dimensionType.f_156647_();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.f_156647_();
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.m_6042_();
        return yBlock > WorldUtil.getDimensionMinHeight(dimensionType) && yBlock < WorldUtil.getDimensionMaxHeight(dimensionType);
    }
}

