/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.coremod.client.gui.modules.GraveyardManagementWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class GraveyardManagementModuleView
extends AbstractBuildingModuleView {
    @NotNull
    private List<BlockPos> graves = new ArrayList<BlockPos>();
    @NotNull
    private List<String> restingCitizen = new ArrayList<String>();

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        this.graves = new ArrayList<BlockPos>();
        int size = buf.readInt();
        for (int i = 1; i <= size; ++i) {
            @NotNull BlockPos pos = buf.m_130135_();
            this.graves.add(pos);
        }
        this.restingCitizen = new ArrayList<String>();
        int sizeRIP = buf.readInt();
        for (int i = 1; i <= sizeRIP; ++i) {
            this.restingCitizen.add(buf.m_130277_());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new GraveyardManagementWindow(this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "grave";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.gui.workerhuts.enchanter.workers";
    }

    @NotNull
    public List<BlockPos> getGraves() {
        return this.graves;
    }

    public void cleanGraves() {
        for (BlockPos grave : new ArrayList<BlockPos>(this.graves)) {
            BlockEntity entity = this.buildingView.getColony().getWorld().m_7702_(grave);
            if (entity instanceof TileEntityGrave) continue;
            this.graves.remove(grave);
        }
    }

    @NotNull
    public List<String> getRestingCitizen() {
        return Collections.unmodifiableList(this.restingCitizen);
    }
}

