/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BuildingAlchemist
extends AbstractBuilding {
    private static final String ALCHEMIST = "alchemist";
    private final List<BlockPos> soulsand = new ArrayList<BlockPos>();
    private final List<BlockPos> leaves = new ArrayList<BlockPos>();
    private final List<BlockPos> brewingStands = new ArrayList<BlockPos>();

    public BuildingAlchemist(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHEARS, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.m_41720_() == Items.f_42588_, new Tuple((Object)16, (Object)false));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return ALCHEMIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block.m_60734_() == Blocks.f_50135_) {
            this.soulsand.add(pos);
        } else if (block.m_204336_(BlockTags.f_13035_)) {
            this.leaves.add(pos);
        } else if (block.m_60734_() == Blocks.f_50255_) {
            this.brewingStands.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        ListTag sandPos = compound.m_128437_("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.soulsand.add(NbtUtils.m_129239_((CompoundTag)sandPos.m_128728_(i).m_128469_("pos")));
        }
        ListTag leavesPos = compound.m_128437_("leaves", 10);
        for (int i = 0; i < leavesPos.size(); ++i) {
            this.leaves.add(NbtUtils.m_129239_((CompoundTag)leavesPos.m_128728_(i).m_128469_("pos")));
        }
        ListTag brewingStandPos = compound.m_128437_("brewingStand", 10);
        for (int i = 0; i < brewingStandPos.size(); ++i) {
            this.brewingStands.add(NbtUtils.m_129239_((CompoundTag)brewingStandPos.m_128728_(i).m_128469_("pos")));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag sandCompoundList = new ListTag();
        for (BlockPos blockPos : this.soulsand) {
            @NotNull CompoundTag sandCompound = new CompoundTag();
            sandCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.m_128365_("plantGround", (Tag)sandCompoundList);
        @NotNull ListTag leavesCompoundList = new ListTag();
        for (BlockPos entry : this.leaves) {
            @NotNull CompoundTag leaveCompound = new CompoundTag();
            leaveCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            leavesCompoundList.add((Object)leaveCompound);
        }
        compound.m_128365_("leaves", (Tag)leavesCompoundList);
        @NotNull ListTag listTag = new ListTag();
        for (BlockPos entry : this.brewingStands) {
            @NotNull CompoundTag brewingStandCompound = new CompoundTag();
            brewingStandCompound.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)entry));
            listTag.add((Object)brewingStandCompound);
        }
        compound.m_128365_("brewingStand", (Tag)listTag);
        return compound;
    }

    public List<BlockPos> getAllSoilPositions() {
        return new ArrayList<BlockPos>(this.soulsand);
    }

    public List<BlockPos> getAllLeavePositions() {
        return new ArrayList<BlockPos>(this.leaves);
    }

    public List<BlockPos> getAllBrewingStandPositions() {
        return new ArrayList<BlockPos>(this.brewingStands);
    }

    public void removeBrewingStand(BlockPos pos) {
        this.brewingStands.remove(pos);
    }

    public void removeSoilPosition(BlockPos pos) {
        this.soulsand.remove(pos);
    }

    public void removeLeafPosition(BlockPos pos) {
        this.leaves.remove(pos);
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return recipe.getPrimaryOutput().m_41720_() == ModItems.magicpotion;
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly() {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly());
            recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)ModItems.mistletoe), Collections.emptyList(), Collections.emptyList(), 1, Blocks.f_50050_, null, ToolType.SHEARS, Collections.emptyList(), -1));
            recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)Items.f_42588_, 4), Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack((ItemLike)Items.f_42588_))), 1, Blocks.f_50135_, null, ToolType.NONE, Collections.emptyList(), -1));
            return recipes;
        }
    }

    public static class BrewingModule
    extends AbstractCraftingBuildingModule.Brewing {
        public BrewingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

