/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.pirates.EntityArcherPirate;
import com.minecolonies.coremod.entity.mobs.pirates.EntityCaptainPirate;
import com.minecolonies.coremod.entity.mobs.pirates.EntityPirate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class PirateGroundRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation PIRATE_GROUND_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "pirate_ground_raid");

    public PirateGroundRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_GROUND_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.m_7003_(true);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
    }

    @Override
    public void onFinish() {
        super.onFinish();
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob) || !entity.m_6084_()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityCaptainPirate && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityArcherPirate && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityPirate && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.m_20148_());
            return;
        }
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesMob)) {
            return;
        }
        if (entity instanceof EntityCaptainPirate) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherPirate) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityPirate) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static PirateGroundRaidEvent loadFromNBT(IColony colony, CompoundTag compound) {
        PirateGroundRaidEvent event = new PirateGroundRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERPIRATE;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFPIRATE;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.raid.pirate.name");
    }
}

