/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling.registry;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.colony.interactionhandling.registry.IInteractionResponseHandlerDataManager;
import com.minecolonies.api.colony.interactionhandling.registry.InteractionResponseHandlerEntry;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.interactionhandling.registry.IInteractionResponseHandlerRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InteractionResponseHandlerManager
implements IInteractionResponseHandlerDataManager {
    @Override
    @Nullable
    public IInteractionResponseHandler createFrom(@NotNull ICitizen citizen, @NotNull CompoundTag compound) {
        ResourceLocation handlerType = compound.m_128441_("handlertype") ? new ResourceLocation("minecolonies", compound.m_128461_("handlertype")) : ModInteractionResponseHandlers.STANDARD;
        IInteractionResponseHandler handler = ((InteractionResponseHandlerEntry)IInteractionResponseHandlerRegistry.getInstance().getValue(handlerType)).getProducer().apply(citizen);
        if (handler != null) {
            try {
                handler.deserializeNBT((Tag)compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("An Interaction %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", handlerType), (Throwable)ex);
                return null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Interaction type '%s' or missing constructor of proper format.", handlerType));
        }
        return handler;
    }
}

