/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers.core;

import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.requestsystem.requesters.IBuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingDependentRequestResolver<R extends IRequestable>
extends AbstractRequestResolver<R>
implements IBuildingBasedRequester {
    public AbstractBuildingDependentRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends R> requestToCheck) {
        ILocation requesterLocation;
        if (!manager.getColony().getWorld().f_46443_ && (requesterLocation = requestToCheck.getRequester().getLocation()).equals(this.getLocation())) {
            Optional<AbstractBuilding> building = this.getBuilding(manager, (IToken<?>)requestToCheck.getId()).map(r -> (AbstractBuilding)r);
            return building.map(b -> this.canResolveForBuilding(manager, (IRequest<? extends R>)requestToCheck, (AbstractBuilding)b)).orElse(false);
        }
        return false;
    }

    public abstract boolean canResolveForBuilding(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2, @NotNull AbstractBuilding var3);

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        return this.attemptResolveForBuilding(manager, request, building);
    }

    @Nullable
    public abstract List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2, @NotNull AbstractBuilding var3);

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        AbstractBuilding building = this.getBuilding(manager, (IToken<?>)request.getId()).map(r -> (AbstractBuilding)r).get();
        this.resolveForBuilding(manager, request, building);
    }

    public abstract void resolveForBuilding(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2, @NotNull AbstractBuilding var3);
}

