/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.journeymap;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.compatibility.journeymap.Journeymap;
import com.minecolonies.coremod.compatibility.journeymap.JourneymapOptions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygonWithHoles;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyBorderMapping {
    private static final Map<ResourceKey<Level>, Map<Integer, ColonyBorderOverlay>> overlays = new HashMap<ResourceKey<Level>, Map<Integer, ColonyBorderOverlay>>();
    static final Codec<List<ColonyBorderOverlay>> DIM_BORDER_CODEC = ColonyBorderOverlay.CODEC.listOf();

    private ColonyBorderMapping() {
    }

    public static String getCurrentColony() {
        BlockPos pos = Minecraft.m_91087_().f_91074_.m_20183_();
        IColony colony = IColonyManager.getInstance().getIColony((Level)Minecraft.m_91087_().f_91073_, pos);
        return colony != null ? colony.getName() : "";
    }

    public static void load(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension) {
        if (overlays.containsKey(dimension)) {
            return;
        }
        Map dimensionOverlays = overlays.computeIfAbsent(dimension, k -> new HashMap());
        Path dataPath = jmap.getDataPath(dimension).resolve("border.json");
        jmap.loadData(dataPath, "colony border data", DIM_BORDER_CODEC).ifPresent(saved -> {
            for (ColonyBorderOverlay overlay : saved) {
                dimensionOverlays.put(overlay.id, overlay);
            }
        });
    }

    public static void unload(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension) {
        Map<Integer, ColonyBorderOverlay> dimensionOverlays = overlays.remove(dimension);
        if (dimensionOverlays != null) {
            for (ColonyBorderOverlay overlay : dimensionOverlays.values()) {
                overlay.unload(jmap);
            }
            Path dataPath = jmap.getDataPath(dimension).resolve("border.json");
            jmap.saveData(dataPath, "colony border data", DIM_BORDER_CODEC, new ArrayList<ColonyBorderOverlay>(dimensionOverlays.values()));
        }
    }

    public static void updateChunk(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension, @NotNull LevelChunk chunk) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null || !dimension.equals((Object)world.m_46472_())) {
            return;
        }
        Map<Integer, ColonyBorderOverlay> dimensionOverlays = overlays.get(dimension);
        if (dimensionOverlays == null) {
            return;
        }
        boolean changed = false;
        int id = ColonyBorderMapping.getOwningColonyForChunk(chunk);
        if (id == 0) {
            for (Map<Integer, ColonyBorderOverlay> overlayMap : overlays.values()) {
                for (ColonyBorderOverlay overlay : overlayMap.values()) {
                    changed |= overlay.updateChunks(Collections.emptySet(), Collections.singleton(chunk.m_7697_()));
                }
            }
        } else {
            IColonyManager colonyManager = MinecoloniesAPIProxy.getInstance().getColonyManager();
            IColonyView colony = colonyManager.getColonyView(id, dimension);
            ColonyBorderOverlay overlay = dimensionOverlays.computeIfAbsent(id, k -> new ColonyBorderOverlay(dimension, id));
            changed |= overlay.updateChunks(Collections.singleton(chunk.m_7697_()), Collections.emptySet());
            changed |= overlay.updateInfo(colony, JourneymapOptions.getShowColonyName(jmap.getOptions()));
        }
    }

    public static void updatePending(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension) {
        IColonyManager colonyManager = MinecoloniesAPIProxy.getInstance().getColonyManager();
        for (Map.Entry colonyEntry : overlays.getOrDefault(dimension, Collections.emptyMap()).entrySet()) {
            ((ColonyBorderOverlay)colonyEntry.getValue()).updatePending(jmap, dimension, (Integer)colonyEntry.getKey(), colonyManager);
        }
    }

    private static int getOwningColonyForChunk(@NotNull LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP).resolve().orElse(null);
        if (cap == null || cap.getOwningColony() < 1) {
            return 0;
        }
        return cap.getOwningColony();
    }

    private static class ColonyBorderOverlay {
        private final ResourceKey<Level> dimension;
        private final int id;
        private final String name;
        private final Set<ChunkPos> chunks;
        private final List<PolygonOverlay> overlays = new ArrayList<PolygonOverlay>();
        private final ShapeProperties fill;
        private final ShapeProperties stroke;
        private final TextProperties text;
        private final TextProperties noText;
        private boolean dirty = false;
        private boolean permitted = true;
        private String colonyName = "";
        private JourneymapOptions.BorderStyle fullscreenStyle = JourneymapOptions.BorderStyle.HIDDEN;
        private JourneymapOptions.BorderStyle minimapStyle = JourneymapOptions.BorderStyle.HIDDEN;
        private static final Codec<Set<ChunkPos>> CODEC_SET_CHUNKPOSLONG = Codec.LONG.xmap(ChunkPos::new, ChunkPos::m_45588_).listOf().xmap(HashSet::new, ArrayList::new);
        static final Codec<ColonyBorderOverlay> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).fieldOf("dimension").forGetter(o -> o.dimension), (App)Codec.INT.fieldOf("id").forGetter(o -> o.id), (App)Codec.STRING.optionalFieldOf("colony_name", null).forGetter(o -> o.colonyName), (App)Codec.INT.optionalFieldOf("colour", (Object)-1).forGetter(o -> o.text.getColor()), (App)Codec.BOOL.optionalFieldOf("licet", (Object)true).forGetter(o -> o.permitted), (App)CODEC_SET_CHUNKPOSLONG.optionalFieldOf("chunks", Collections.emptySet()).forGetter(o -> o.chunks)).apply((Applicative)instance, ColonyBorderOverlay::new));

        private ColonyBorderOverlay(@NotNull ResourceKey<Level> dimension, int id, String colonyName, int colour, boolean permitted, @NotNull Set<ChunkPos> chunks) {
            this(dimension, id);
            this.chunks.addAll(chunks);
            this.updateInfo(colonyName, colour, permitted, true);
            this.dirty = true;
        }

        public ColonyBorderOverlay(@NotNull ResourceKey<Level> dimension, int id) {
            this.dimension = dimension;
            this.id = id;
            this.name = String.format("colony_%s_%d", dimension.m_135782_(), id);
            this.chunks = new HashSet<ChunkPos>();
            this.fill = new ShapeProperties().setStrokeWidth(4.0f).setStrokeColor(65280).setStrokeOpacity(0.7f).setFillColor(65280).setFillOpacity(0.2f);
            this.stroke = new ShapeProperties().setStrokeWidth(4.0f).setStrokeColor(65280).setStrokeOpacity(0.7f).setFillColor(65280).setFillOpacity(0.0f);
            this.text = new TextProperties().setBackgroundColor(34).setBackgroundOpacity(0.5f).setColor(65280).setOpacity(1.0f).setMinZoom(0).setMaxZoom(2).setScale(2.0f).setFontShadow(true);
            this.noText = new TextProperties().setActiveUIs(EnumSet.noneOf(Context.UI.class));
        }

        public boolean updateChunks(@NotNull Set<ChunkPos> addChunks, @NotNull Set<ChunkPos> removeChunks) {
            boolean changed = this.chunks.addAll(addChunks);
            this.dirty |= (changed |= this.chunks.removeAll(removeChunks));
            return changed;
        }

        public boolean updateInfo(@Nullable IColonyView colony, boolean showColonyName) {
            boolean changed = false;
            if (colony != null) {
                boolean permitted = colony.getPermissions().hasPermission((Player)Minecraft.m_91087_().f_91074_, Action.MAP_BORDER);
                changed |= this.updateInfo(colony.getName(), colony.getTeamColonyColor().m_126665_(), permitted, showColonyName);
            }
            return changed;
        }

        private boolean updateInfo(@Nullable String colonyName, int colour, boolean permitted, boolean showColonyName) {
            boolean changed = !Objects.equals(colonyName, this.colonyName) || this.text.getColor() != colour || this.permitted != permitted;
            this.fill.setFillColor(colour).setStrokeColor(colour);
            this.stroke.setStrokeColor(colour);
            this.text.setColor(colour);
            this.text.setBackgroundColor(colour == ChatFormatting.BLACK.m_126665_() ? 0xDDDDDD : 34);
            this.colonyName = colonyName;
            this.permitted = permitted;
            for (PolygonOverlay overlay : this.overlays) {
                overlay.setLabel(showColonyName ? this.colonyName : "");
            }
            return changed;
        }

        public void updatePending(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension, int id, @NotNull IColonyManager colonyManager) {
            IColonyView colony = colonyManager.getColonyView(id, dimension);
            JourneymapOptions.BorderStyle fullscreenStyle = JourneymapOptions.getBorderFullscreenStyle(jmap.getOptions());
            JourneymapOptions.BorderStyle minimapStyle = JourneymapOptions.getBorderMinimapStyle(jmap.getOptions());
            boolean enabled = this.permitted && (!JourneymapOptions.BorderStyle.HIDDEN.equals((Object)fullscreenStyle) || !JourneymapOptions.BorderStyle.HIDDEN.equals((Object)minimapStyle));
            this.dirty |= !enabled && !this.overlays.isEmpty();
            this.dirty |= enabled && this.overlays.isEmpty() && !this.chunks.isEmpty();
            this.dirty |= !fullscreenStyle.equals((Object)this.fullscreenStyle);
            this.dirty |= !minimapStyle.equals((Object)this.minimapStyle);
            if (this.dirty) {
                this.fullscreenStyle = fullscreenStyle;
                this.minimapStyle = minimapStyle;
                this.unload(jmap);
                if (!this.chunks.isEmpty() && enabled && jmap.getApi().playerAccepts("minecolonies", DisplayType.Polygon)) {
                    this.dirty = false;
                    List polygons = PolygonHelper.createChunksPolygon(this.chunks, (int)256);
                    int index = 0;
                    for (MapPolygonWithHoles polygon : polygons) {
                        ShapeProperties shape;
                        if (!JourneymapOptions.BorderStyle.HIDDEN.equals((Object)fullscreenStyle)) {
                            shape = JourneymapOptions.BorderStyle.FILLED.equals((Object)fullscreenStyle) ? this.fill : this.stroke;
                            PolygonOverlay overlay = new PolygonOverlay("minecolonies", String.format("%s_%s", this.name, ++index), this.dimension, shape, polygon.hull, polygon.holes);
                            overlay.setOverlayGroupName(this.name).setActiveUIs(EnumSet.of(Context.UI.Fullscreen, Context.UI.Webmap)).setTextProperties(this.text).setLabel(this.colonyName);
                            this.overlays.add(overlay);
                            jmap.show((Displayable)overlay);
                        }
                        if (JourneymapOptions.BorderStyle.HIDDEN.equals((Object)minimapStyle)) continue;
                        shape = JourneymapOptions.BorderStyle.FILLED.equals((Object)minimapStyle) ? this.fill : this.stroke;
                        PolygonOverlay mini = new PolygonOverlay("minecolonies", String.format("%s_%s", this.name, ++index), this.dimension, shape, polygon.hull, polygon.holes);
                        mini.setOverlayGroupName(this.name).setActiveUIs(EnumSet.of(Context.UI.Minimap)).setTextProperties(this.noText);
                        this.overlays.add(mini);
                        jmap.show((Displayable)mini);
                    }
                }
            }
        }

        public void unload(@NotNull Journeymap jmap) {
            for (PolygonOverlay overlay : this.overlays) {
                jmap.getApi().remove((Displayable)overlay);
            }
            this.overlays.clear();
        }
    }
}

