/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.minecolonies.api.entity.ai.citizen.guards.GuardGear;
import com.minecolonies.api.entity.ai.citizen.guards.GuardGearBuilder;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIFight<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIInteract<J, B> {
    public final List<ToolType> toolsNeeded = new ArrayList<ToolType>();
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();
    protected LivingEntity target = null;
    private static final double COMBAT_SPEED = 1.0;
    public static final double SPEED_LEVEL_BONUS = 0.01;

    public AbstractEntityAIFight(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 100), new AITarget<Object>(AIWorkerState.PREPARING, this::prepare, 20));
        this.worker.m_21553_(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
    }

    protected IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepare() {
        for (ToolType tool : this.toolsNeeded) {
            if (this.checkForToolOrWeapon(tool)) {
                return this.getState();
            }
            InventoryFunctions.matchFirstInProviderWithSimpleAction((ICapabilityProvider)this.worker, stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.doesItemServeAsWeapon(stack) && ItemStackUtils.hasToolLevel(stack, tool, 0, ((AbstractBuildingGuards)this.building).getMaxToolLevel()), itemStack -> this.worker.getCitizenItemHandler().setMainHeldItem((int)itemStack));
        }
        this.equipInventoryArmor();
        if (this.worker.m_20183_().m_123331_((Vec3i)((AbstractBuildingGuards)this.building).getID()) > 50.0) {
            return AIWorkerState.DECIDE;
        }
        this.atBuildingActions();
        return AIWorkerState.DECIDE;
    }

    protected void atBuildingActions() {
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                int slot;
                Map<IItemHandler, List<Integer>> items;
                if (((AbstractBuildingGuards)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((AbstractBuildingGuards)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired() || item.getItemNeeded() == ToolType.SHIELD && this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) <= 0.0) continue;
                int bestSlot = -1;
                int bestLevel = -1;
                IItemHandler bestHandler = null;
                if (!ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType())).booleanValue()) {
                    bestLevel = ItemStackUtils.getMiningLevel(this.worker.m_6844_(item.getType()), item.getItemNeeded());
                }
                if ((items = InventoryUtils.findAllSlotsInProviderWith(this.building, item::test)).isEmpty()) {
                    if (ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType())).booleanValue()) {
                        this.checkForToolorWeaponASync(item.getItemNeeded(), item.getMinArmorLevel(), item.getMaxArmorLevel());
                    }
                } else {
                    for (Map.Entry<IItemHandler, List<Integer>> entry : items.entrySet()) {
                        for (Integer slot2 : entry.getValue()) {
                            int currentLevel;
                            ItemStack stack2 = entry.getKey().getStackInSlot(slot2.intValue());
                            if (ItemStackUtils.isEmpty(stack2).booleanValue() || (currentLevel = ItemStackUtils.getMiningLevel(stack2, item.getItemNeeded())) <= bestLevel) continue;
                            bestLevel = currentLevel;
                            bestSlot = slot2;
                            bestHandler = entry.getKey();
                        }
                    }
                }
                if (bestHandler == null) continue;
                if (!ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType())).booleanValue() && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == this.worker.m_6844_(item.getType()))) > -1) {
                    InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot, this.building);
                }
                this.worker.m_8061_(item.getType(), bestHandler.getStackInSlot(bestSlot));
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
        this.equipInventoryArmor();
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PREPARING;
    }

    public void equipInventoryArmor() {
        this.cleanArmor();
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                if (!ItemStackUtils.isEmpty(this.worker.m_6844_(item.getType())).booleanValue() || ((AbstractBuildingGuards)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((AbstractBuildingGuards)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                int slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), item::test);
                if (slot <= -1) continue;
                this.worker.m_8061_(item.getType(), this.worker.getInventoryCitizen().getStackInSlot(slot));
            }
        }
    }

    public void cleanArmor() {
        this.updateArmorInSlot(EquipmentSlot.CHEST);
        this.updateArmorInSlot(EquipmentSlot.FEET);
        this.updateArmorInSlot(EquipmentSlot.HEAD);
        this.updateArmorInSlot(EquipmentSlot.LEGS);
        this.updateArmorInSlot(EquipmentSlot.OFFHAND);
    }

    private void updateArmorInSlot(EquipmentSlot type) {
        ItemStack stack = this.worker.m_6844_(type);
        if (stack.m_41619_() || InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack, false, true)) == -1) {
            this.worker.m_8061_(type, ItemStackUtils.EMPTY);
        }
    }
}

