/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.cook;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobCook;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCook
extends AbstractEntityAIUsesFurnace<JobCook, BuildingCook> {
    public static final int SATURATION_TO_SERVE = 16;
    private static final int SERVE_DELAY = 30;
    private static final int LEVEL_TO_FEED_PLAYER = 10;
    private final List<AbstractEntityCitizen> citizenToServe = new ArrayList<AbstractEntityCitizen>();
    private final List<Player> playerToServe = new ArrayList<Player>();
    private static final VisibleCitizenStatus COOK = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cook.png"), "com.minecolonies.gui.visiblestatus.cook");
    private Set<ItemStorage> reservedItemCache = new HashSet<ItemStorage>();

    public EntityAIWorkCook(@NotNull JobCook job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN, this::serveFoodToCitizen, 30));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingCook> getExpectedBuildingClass() {
        return BuildingCook.class;
    }

    @Override
    protected void extractFromFurnace(FurnaceBlockEntity furnace) {
        if (!((BuildingCook)this.building).getIsCooking()) {
            InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler((IItemHandler)new InvWrapper((Container)furnace), 2, (IItemHandler)this.worker.getInventoryCitizen());
            this.worker.getCitizenExperienceHandler().addExperience(2.0);
            this.incrementActionsDoneAndDecSaturation();
        }
    }

    @Override
    public IAIState startWorking() {
        this.reservedItemCache.clear();
        return super.startWorking();
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        if (!((BuildingCook)this.building).getIsCooking()) {
            return ItemStackUtils.ISCOOKABLE.test(stack) && !this.isItemStackForAssistant(stack) && !((ItemListModule)((BuildingCook)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("food"))).isItemInList(new ItemStorage(MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack)));
        }
        return false;
    }

    @Override
    protected boolean reachedMaxToKeep() {
        if (super.reachedMaxToKeep()) {
            return true;
        }
        int buildingLimit = Math.max(1, ((BuildingCook)this.building).getBuildingLevel() * ((BuildingCook)this.building).getBuildingLevel()) * 9;
        return InventoryUtils.getCountFromBuildingWithLimit(this.building, ItemStackUtils.CAN_EAT.and(stack -> stack.m_41720_().getFoodProperties(stack, (LivingEntity)this.worker).m_38744_() >= ((BuildingCook)this.building).getBuildingLevel() - 1), stack -> stack.m_41741_() * 6) > buildingLimit;
    }

    @Override
    public void requestSmeltable() {
        IRequestable smeltable = this.getSmeltAbleClass();
        if (smeltable != null && !((BuildingCook)this.building).hasWorkerOpenRequestsOfType(-1, TypeToken.of(smeltable.getClass())) && !((BuildingCook)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(smeltable.getClass()))) {
            ((BuildingCook)this.building).createRequest(smeltable, true);
        }
    }

    private IAIState serveFoodToCitizen() {
        Object handler;
        Entity living;
        if (this.citizenToServe.isEmpty() && this.playerToServe.isEmpty()) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenData().setVisibleStatus(COOK);
        Entity entity = living = this.citizenToServe.isEmpty() ? (Entity)this.playerToServe.get(0) : (Entity)this.citizenToServe.get(0);
        if (!((BuildingCook)this.building).isInBuilding(living.m_20183_())) {
            this.worker.getNavigation().m_26573_();
            this.removeFromQueue();
            return AIWorkerState.START_WORKING;
        }
        if (this.walkToBlock(new BlockPos(living.m_20182_()))) {
            return this.getState();
        }
        Object object = handler = this.citizenToServe.isEmpty() ? new InvWrapper((Container)this.playerToServe.get(0).m_150109_()) : this.citizenToServe.get(0).getInventoryCitizen();
        if (InventoryUtils.isItemHandlerFull((IItemHandler)handler)) {
            int foodSlot;
            if (!this.citizenToServe.isEmpty() && (foodSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack, this.citizenToServe.isEmpty() ? null : this.citizenToServe.get(0)))) != -1) {
                ItemStack stack2 = this.worker.getInventoryCitizen().extractItem(foodSlot, 1, false);
                if (stack2.m_41614_()) {
                    this.citizenToServe.get(0).getCitizenData().increaseSaturation((double)stack2.m_41720_().getFoodProperties(stack2, (LivingEntity)this.worker).m_38744_() / 2.0);
                }
                this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("food_served");
            }
            this.removeFromQueue();
            return this.getState();
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)handler, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack, this.citizenToServe.isEmpty() ? null : this.citizenToServe.get(0)))) {
            this.removeFromQueue();
            return this.getState();
        }
        int count = InventoryUtils.transferFoodUpToSaturation((ICapabilityProvider)this.worker, (IItemHandler)handler, ((BuildingCook)this.building).getBuildingLevel() * 16, stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack, this.citizenToServe.isEmpty() ? null : this.citizenToServe.get(0)));
        if (count <= 0) {
            this.removeFromQueue();
            return this.getState();
        }
        this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().incrementBy("food_served", count);
        if (!this.citizenToServe.isEmpty() && this.citizenToServe.get(0).getCitizenData() != null) {
            this.citizenToServe.get(0).getCitizenData().setJustAte(true);
        }
        if (this.citizenToServe.isEmpty() && living instanceof Player) {
            MessageUtils.format("com.minecolonies.coremod.cook.serve.player", this.worker.m_7755_().getString()).sendTo((Player)living);
        }
        this.removeFromQueue();
        this.worker.getCitizenExperienceHandler().addExperience(2.0);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    private boolean canEat(ItemStack stack, AbstractEntityCitizen citizen) {
        IBuilding building;
        ItemListModule module = (ItemListModule)this.worker.getCitizenData().getWorkBuilding().getModuleMatching(ItemListModule.class, m -> m.getId().equals("food"));
        if (module.isItemInList(new ItemStorage(stack))) {
            return false;
        }
        if (citizen != null && (building = citizen.getCitizenData().getWorkBuilding()) != null) {
            return building.canEat(stack);
        }
        return true;
    }

    private void removeFromQueue() {
        if (this.citizenToServe.isEmpty()) {
            this.playerToServe.remove(0);
        } else {
            this.citizenToServe.remove(0);
        }
    }

    @Override
    protected IAIState checkForImportantJobs() {
        this.reservedItemCache.clear();
        this.citizenToServe.clear();
        List citizenList = WorldUtil.getEntitiesWithinBuilding(this.world, AbstractEntityCitizen.class, this.building, null).stream().filter(cit -> !(cit.getCitizenJobHandler().getColonyJob() instanceof JobCook) && this.shouldBeFed((AbstractEntityCitizen)cit) && !InventoryUtils.hasItemInItemHandler(cit.getItemHandlerCitizen(), stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack, (AbstractEntityCitizen)cit))).sorted(Comparator.comparingInt(a -> a.getCitizenJobHandler().getColonyJob() == null ? 1 : 0)).collect(Collectors.toList());
        List<Player> playerList = WorldUtil.getEntitiesWithinBuilding(this.world, Player.class, this.building, player -> player != null && player.m_36324_().m_38702_() < 10 && ((BuildingCook)this.building).getColony().getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS));
        this.playerToServe.addAll(playerList);
        boolean hasFoodInBuilding = false;
        for (AbstractEntityCitizen citizen : citizenList) {
            Predicate<ItemStack> foodPredicate = stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && !this.isItemStackForAssistant((ItemStack)stack) && this.canEat((ItemStack)stack, citizen);
            if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), foodPredicate)) {
                this.citizenToServe.add(citizen);
                continue;
            }
            if (!InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, foodPredicate)) continue;
            hasFoodInBuilding = true;
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(foodPredicate, 64);
        }
        if (!this.playerToServe.isEmpty()) {
            Predicate<ItemStack> foodPredicate = stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && !this.isItemStackForAssistant((ItemStack)stack);
            if (!InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), foodPredicate) && InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, foodPredicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(foodPredicate, 64);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
        }
        if (!this.citizenToServe.isEmpty() || !this.playerToServe.isEmpty()) {
            return AIWorkerState.COOK_SERVE_FOOD_TO_CITIZEN;
        }
        if (hasFoodInBuilding) {
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIWorkerState.START_WORKING;
    }

    private boolean shouldBeFed(AbstractEntityCitizen citizen) {
        return citizen.getCitizenData() != null && citizen.getCitizenData().getSaturation() <= 10.0 && !citizen.getCitizenData().justAte();
    }

    private boolean isItemStackForAssistant(ItemStack stack) {
        if (this.reservedItemCache.isEmpty()) {
            this.reservedItemCache.addAll(((BuildingCook.CraftingModule)((BuildingCook)this.building).getFirstModuleOccurance(BuildingCook.CraftingModule.class)).reservedStacks().keySet());
        }
        return this.reservedItemCache.contains(new ItemStorage(stack));
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        ArrayList<ItemStorage> blockedItems = new ArrayList<ItemStorage>((Collection<ItemStorage>)((ItemListModule)((BuildingCook)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("food"))).getList());
        for (Map.Entry<ItemStorage, Integer> content : ((BuildingCook)this.building).getTileEntity().getAllContent().entrySet()) {
            if (content.getValue() <= content.getKey().getItemStack().m_41741_() * 6 || !ItemStackUtils.CAN_EAT.test(content.getKey().getItemStack())) continue;
            blockedItems.add(content.getKey());
        }
        blockedItems.removeIf(item -> item.getItem().getFoodProperties(item.getItemStack(), (LivingEntity)this.worker) == null || item.getItem().getFoodProperties(item.getItemStack(), (LivingEntity)this.worker).m_38744_() < ((BuildingCook)this.building).getBuildingLevel() - 1);
        if (!blockedItems.isEmpty()) {
            if (IColonyManager.getInstance().getCompatibilityManager().getEdibles(((BuildingCook)this.building).getBuildingLevel() - 1).size() <= blockedItems.size() && this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.furnaceuser.nofood"), ChatPriority.BLOCKING));
                return null;
            }
            return new Food(64, blockedItems, ((BuildingCook)this.building).getBuildingLevel() - 1);
        }
        return new Food(64, ((BuildingCook)this.building).getBuildingLevel() - 1);
    }
}

