/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.enchanter;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.EnchanterStationsModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobEnchanter;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.StreamParticleEffectMessage;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkEnchanter
extends AbstractEntityAICrafting<JobEnchanter, BuildingEnchanter> {
    private static final Predicate<ItemStack> IS_ANCIENT_TOME = item -> !item.m_41619_() && item.m_41720_() == ModItems.ancientTome;
    private static final Predicate<ItemStack> IS_BOOK = item -> !item.m_41619_() && item.m_41720_() == Items.f_42517_;
    private static final long MIN_DISTANCE_TO_DRAIN = 10L;
    private static final int MAX_PROGRESS_TICKS = 60;
    private static final int MAX_ENCHANTMENT_TICKS = 300;
    private static final int MANA_REQ_PER_LEVEL = 10;
    private static final double XP_PER_DRAIN = 10.0;
    private ICitizenData citizenToGatherFrom = null;
    private int progressTicks = 0;

    public EntityAIWorkEnchanter(@NotNull JobEnchanter job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 20), new AITarget<AIWorkerState>(AIWorkerState.START_WORKING, AIWorkerState.DECIDE, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decide, 20), new AITarget<Object>(AIWorkerState.ENCHANTER_DRAIN, this::gatherAndDrain, 10), new AITarget<Object>(AIWorkerState.ENCHANT, this::enchant, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected IAIState decide() {
        this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (this.walkToBuilding()) {
            return AIWorkerState.DECIDE;
        }
        IAIState craftState = this.getNextCraftingState();
        if (craftState != this.getState() && !WorldUtil.isPastTime(this.world, 13000)) {
            return craftState;
        }
        if (this.getPrimarySkillLevel() < ((BuildingEnchanter)this.building).getBuildingLevel() * 10) {
            BuildingEnchanter enchanterBuilding = (BuildingEnchanter)this.building;
            EnchanterStationsModule module = (EnchanterStationsModule)enchanterBuilding.getFirstModuleOccurance(EnchanterStationsModule.class);
            if (module.getBuildingsToGatherFrom().isEmpty()) {
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.enchanter.nodrainingsset"), ChatPriority.BLOCKING));
                }
                return AIWorkerState.IDLE;
            }
            int booksInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_BOOK);
            if (booksInInv <= 0) {
                int numberOfBooksInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, IS_BOOK, 1);
                if (numberOfBooksInBuilding > 0) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(IS_BOOK, 1);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.f_42517_, 1));
                return AIWorkerState.IDLE;
            }
            BlockPos posToDrainFrom = module.getRandomBuildingToDrainFrom();
            if (posToDrainFrom == null) {
                return AIWorkerState.IDLE;
            }
            ((JobEnchanter)this.job).setBuildingToDrainFrom(posToDrainFrom);
            return AIWorkerState.ENCHANTER_DRAIN;
        }
        int ancientTomesInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_ANCIENT_TOME);
        if (ancientTomesInInv <= 0) {
            int amountOfAncientTomes = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, IS_ANCIENT_TOME, 1);
            if (amountOfAncientTomes > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(IS_ANCIENT_TOME, 1);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)ModItems.ancientTome, 1), 1, 1, false);
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.ENCHANT;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState enchant() {
        List<ItemStack> loot;
        this.currentRecipeStorage = ((BuildingEnchanter.CraftingModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(BuildingEnchanter.CraftingModule.class)).getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        if (this.currentRecipeStorage == null) {
            this.progressTicks = 0;
            return AIWorkerState.DECIDE;
        }
        if (this.progressTicks++ < 300 / ((BuildingEnchanter)this.building).getBuildingLevel()) {
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 2.0, 0.0), ParticleTypes.f_123809_, this.progressTicks), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 1.5, 0.0), ParticleTypes.f_123809_, this.progressTicks), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(this.worker.m_20182_().m_82520_(0.0, 1.0, 0.0), ParticleTypes.f_123809_, this.progressTicks), (Entity)this.worker);
            this.worker.queueSound(SoundEvents.f_11887_, this.worker.m_20183_().m_7494_(), 20, 0, 0.5f, this.worker.m_217043_().m_188501_());
            if (this.worker.m_217043_().m_188499_()) {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
            } else {
                this.worker.m_6674_(InteractionHand.OFF_HAND);
            }
            return this.getState();
        }
        ICitizenData data = this.worker.getCitizenData();
        if (data != null && (loot = this.currentRecipeStorage.fullfillRecipeAndCopy(this.getLootContext(), ((BuildingEnchanter)this.building).getHandlers(), true)) != null) {
            int enchantmentLevel = loot.stream().mapToInt(EntityAIWorkEnchanter::getEnchantedBookLevel).max().orElse(0);
            data.getCitizenSkillHandler().incrementLevel(Skill.Mana, -enchantmentLevel);
            this.incrementActionsDoneAndDecSaturation();
        }
        this.currentRecipeStorage = null;
        this.progressTicks = 0;
        return AIWorkerState.IDLE;
    }

    private static int getEnchantedBookLevel(@NotNull ItemStack stack) {
        if (stack.m_41720_().equals(Items.f_42690_)) {
            return EnchantedBookItem.m_41163_((ItemStack)stack).stream().mapToInt(nbt -> ((CompoundTag)nbt).m_128448_("lvl")).max().orElse(0);
        }
        return 0;
    }

    private IAIState gatherAndDrain() {
        if (((JobEnchanter)this.job).getPosToDrainFrom() == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBlock(((JobEnchanter)this.job).getPosToDrainFrom())) {
            return this.getState();
        }
        AbstractBuilding buildingWorker = ((BuildingEnchanter)this.building).getColony().getBuildingManager().getBuilding(((JobEnchanter)this.job).getPosToDrainFrom(), AbstractBuilding.class);
        if (buildingWorker == null) {
            this.resetDraining();
            ((EnchanterStationsModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(EnchanterStationsModule.class)).removeWorker(((JobEnchanter)this.job).getPosToDrainFrom());
            return AIWorkerState.IDLE;
        }
        if (this.citizenToGatherFrom == null) {
            AbstractEntityCitizen citizen;
            ArrayList workers = new ArrayList();
            for (Optional<AbstractEntityCitizen> citizen2 : this.getModuleForJob().getAssignedEntities()) {
                citizen2.ifPresent(workers::add);
            }
            if (workers.size() > 1) {
                citizen = (AbstractEntityCitizen)workers.get(this.worker.m_217043_().m_188503_(workers.size()));
            } else {
                if (workers.isEmpty()) {
                    this.resetDraining();
                    return AIWorkerState.DECIDE;
                }
                citizen = (AbstractEntityCitizen)workers.get(0);
            }
            this.citizenToGatherFrom = citizen.getCitizenData();
            this.progressTicks = 0;
            return this.getState();
        }
        if (!this.citizenToGatherFrom.getEntity().isPresent()) {
            this.citizenToGatherFrom = null;
            return this.getState();
        }
        if (this.progressTicks == 0 && BlockPosUtil.getDistance2D(this.citizenToGatherFrom.getEntity().get().m_20183_(), this.worker.m_20183_()) > 10L) {
            if (!((JobEnchanter)this.job).incrementWaitingTicks()) {
                this.resetDraining();
                return AIWorkerState.DECIDE;
            }
            return this.getState();
        }
        ++this.progressTicks;
        if (this.progressTicks < 60) {
            Vec3 start = this.worker.m_20182_().m_82520_(0.0, 2.0, 0.0);
            Vec3 goal = this.citizenToGatherFrom.getEntity().get().m_20182_().m_82520_(0.0, 2.0, 0.0);
            Network.getNetwork().sendToTrackingEntity(new StreamParticleEffectMessage(start, goal, ParticleTypes.f_123809_, this.progressTicks % 60, 60), (Entity)this.worker);
            Network.getNetwork().sendToTrackingEntity(new CircleParticleEffectMessage(start, ParticleTypes.f_123748_, this.progressTicks), (Entity)this.worker);
            WorkerUtil.faceBlock(new BlockPos(goal), this.worker);
            if (this.worker.m_217043_().m_188499_()) {
                this.worker.m_6674_(InteractionHand.MAIN_HAND);
            } else {
                this.worker.m_6674_(InteractionHand.OFF_HAND);
            }
            return this.getState();
        }
        int bookSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), Items.f_42517_);
        if (bookSlot != -1) {
            int size = this.citizenToGatherFrom.getInventory().getSlots();
            int attempts = (int)((double)this.getSecondarySkillLevel() / 5.0);
            for (int i = 0; i < attempts; ++i) {
                int randomSlot = this.worker.m_217043_().m_188503_(size);
                ItemStack stack = this.citizenToGatherFrom.getInventory().getStackInSlot(randomSlot);
                if (stack.m_41619_() || !stack.m_41792_()) continue;
                EnchantmentHelper.m_220292_((RandomSource)this.worker.m_217043_(), (ItemStack)stack, (int)(this.getSecondarySkillLevel() > 50 ? 2 : 1), (boolean)false);
                break;
            }
            this.worker.getInventoryCitizen().extractItem(bookSlot, 1, false);
            this.worker.getCitizenData().getCitizenSkillHandler().incrementLevel(Skill.Mana, 1);
            this.worker.getCitizenExperienceHandler().addExperience(10.0);
            this.worker.getCitizenData().markDirty();
        }
        this.resetDraining();
        return AIWorkerState.IDLE;
    }

    private void resetDraining() {
        ((EnchanterStationsModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(EnchanterStationsModule.class)).setAsGathered(((JobEnchanter)this.job).getPosToDrainFrom());
        this.citizenToGatherFrom = null;
        ((JobEnchanter)this.job).setBuildingToDrainFrom(null);
        this.progressTicks = 0;
        this.incrementActionsDoneAndDecSaturation();
    }

    @Override
    public Class<BuildingEnchanter> getExpectedBuildingClass() {
        return BuildingEnchanter.class;
    }
}

