/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.coremod.colony.jobs.JobCowboy;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkCowboy
extends AbstractEntityAIHerder<JobCowboy, BuildingCowboy> {
    public static final String RENDER_META_BUCKET = "bucket";
    public static final String RENDER_META_BOWL = "bowl";
    private static final VisibleCitizenStatus HERD_COW = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/cowboy.png"), "com.minecolonies.gui.visiblestatus.cowboy");
    private static final int MILK_COOL_DOWN = 10;
    private int milkCoolDown;
    private int stewCoolDown;

    public EntityAIWorkCowboy(@NotNull JobCowboy job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COWBOY_MILK, this::milkCows, 1), new AITarget<Object>(AIWorkerState.COWBOY_STEW, this::milkMooshrooms, 1));
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42446_)) {
            renderMeta = (String)renderMeta + RENDER_META_BUCKET;
        }
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42399_)) {
            renderMeta = (String)renderMeta + RENDER_META_BOWL;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    public Class<BuildingCowboy> getExpectedBuildingClass() {
        return BuildingCowboy.class;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        if (this.milkCoolDown > 0) {
            --this.milkCoolDown;
        } else if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToMilk() && result.equals(AIWorkerState.START_WORKING)) {
            return AIWorkerState.COWBOY_MILK;
        }
        if (this.stewCoolDown > 0) {
            --this.stewCoolDown;
        } else if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToStew() && result.equals(AIWorkerState.START_WORKING)) {
            return AIWorkerState.COWBOY_STEW;
        }
        return result;
    }

    @Override
    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        List<ItemStack> list = super.getExtraItemsNeeded();
        if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToMilk() && !this.searchForAnimals(a -> a instanceof Cow && !(a instanceof MushroomCow)).isEmpty()) {
            list.add(new ItemStack((ItemLike)Items.f_42446_));
        }
        if (this.building != null && ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).canTryToStew() && !this.searchForAnimals(a -> a instanceof MushroomCow).isEmpty()) {
            list.add(new ItemStack((ItemLike)Items.f_42399_));
        }
        return list;
    }

    private IAIState milkCows() {
        Cow cow;
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42446_)) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, new ItemStorage(new ItemStack((ItemLike)Items.f_42446_, 1)), 1) > 0 && !this.walkToBuilding()) {
                this.checkAndTransferFromHut(new ItemStack((ItemLike)Items.f_42446_, 1));
            } else {
                this.milkCoolDown = 10;
                return AIWorkerState.DECIDE;
            }
        }
        if ((cow = (Cow)this.searchForAnimals(a -> a instanceof Cow && !(a instanceof MushroomCow) && !a.m_6162_()).stream().map(a -> (Cow)a).findFirst().orElse(null)) == null) {
            this.milkCoolDown = 10;
            return AIWorkerState.DECIDE;
        }
        if (this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(new ItemStack((ItemLike)Items.f_42446_))) && !this.walkingToAnimal((Animal)cow)) {
            if (InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.f_42455_))) {
                ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).onMilked();
                this.worker.getCitizenItemHandler().removeHeldItem();
                this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(new ItemStack((ItemLike)Items.f_42455_)));
                InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.f_42446_, 1));
            }
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            return AIWorkerState.INVENTORY_FULL;
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState milkMooshrooms() {
        MushroomCow mooshroom;
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        if (!this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.f_42399_)) {
            if (InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, new ItemStorage(new ItemStack((ItemLike)Items.f_42399_, 1)), 1) > 0 && !this.walkToBuilding()) {
                this.checkAndTransferFromHut(new ItemStack((ItemLike)Items.f_42399_, 1));
            } else {
                this.stewCoolDown = 10;
                return AIWorkerState.DECIDE;
            }
        }
        if ((mooshroom = (MushroomCow)this.searchForAnimals(a -> a instanceof MushroomCow && !a.m_6162_()).stream().map(a -> (MushroomCow)a).findFirst().orElse(null)) == null) {
            this.stewCoolDown = 10;
            return AIWorkerState.DECIDE;
        }
        if (this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(new ItemStack((ItemLike)Items.f_42399_))) && !this.walkingToAnimal((Animal)mooshroom)) {
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.worker.m_9236_()));
            fakePlayer.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42399_));
            if (mooshroom.m_6071_((Player)fakePlayer, InteractionHand.MAIN_HAND).equals((Object)InteractionResult.CONSUME)) {
                if (InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), fakePlayer.m_21205_())) {
                    ((BuildingCowboy.HerdingModule)((BuildingCowboy)this.building).getFirstModuleOccurance(BuildingCowboy.HerdingModule.class)).onStewed();
                    this.worker.getCitizenItemHandler().removeHeldItem();
                    this.equipItem(InteractionHand.MAIN_HAND, Collections.singletonList(fakePlayer.m_21205_()));
                    InventoryUtils.tryRemoveStackFromItemHandler((IItemHandler)this.worker.getInventoryCitizen(), new ItemStack((ItemLike)Items.f_42399_));
                }
                fakePlayer.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            return AIWorkerState.INVENTORY_FULL;
        }
        return AIWorkerState.DECIDE;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getPrimarySkillLevel() / 10.0);
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(HERD_COW);
        return super.butcherAnimals();
    }
}

