/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.student;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.util.StudyItem;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.colony.jobs.JobStudent;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAISkill;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIStudy
extends AbstractEntityAISkill<JobStudent, BuildingLibrary> {
    public static final String RENDER_META_BOOK = "book";
    public static final String RENDER_META_STUDYING = "study";
    private static final int STUDY_DELAY = 1200;
    public static final int ONE_IN_X_CHANCE = 8;
    private BlockPos studyPos = null;

    public EntityAIStudy(@NotNull JobStudent job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.STUDY, this::study, 5));
        this.worker.m_21553_(true);
    }

    @Override
    protected void updateRenderMetaData() {
        Object renderMeta;
        Object object = renderMeta = this.getState() == AIWorkerState.IDLE ? "" : "working";
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> itemStack.m_41720_() == Items.f_42517_ || itemStack.m_41720_() == Items.f_42516_)) {
            renderMeta = (String)renderMeta + RENDER_META_BOOK;
        }
        if (this.worker.getNavigation().m_26571_()) {
            renderMeta = (String)renderMeta + RENDER_META_STUDYING;
        }
        this.worker.setRenderMetadata((String)renderMeta);
    }

    @Override
    public Class<BuildingLibrary> getExpectedBuildingClass() {
        return BuildingLibrary.class;
    }

    private IAIState study() {
        ICitizenData data = this.worker.getCitizenData();
        if (this.studyPos == null) {
            this.studyPos = ((BuildingLibrary)this.building).getRandomBookShelf();
        }
        if (this.walkToBlock(this.studyPos)) {
            this.setDelay(20);
            return this.getState();
        }
        ArrayList<StudyItem> currentItems = new ArrayList<StudyItem>();
        for (StudyItem curItem : ((BuildingLibrary)this.building).getStudyItems()) {
            int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.worker, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.m_41720_() == curItem.getItem());
            if (slot == -1) continue;
            curItem.setSlot(slot);
            currentItems.add(curItem);
        }
        if (currentItems.isEmpty()) {
            for (StudyItem studyItem : ((BuildingLibrary)this.building).getStudyItems()) {
                int bSlot = InventoryUtils.findFirstSlotInProviderWith((ICapabilityProvider)this.building, studyItem.getItem());
                if (bSlot > -1) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(itemStack -> studyItem.getItem() == itemStack.m_41720_(), 10);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)studyItem.getItem(), studyItem.getBreakPct() / 10 > 0 ? studyItem.getBreakPct() / 10 : 1));
            }
            data.getCitizenSkillHandler().tryLevelUpIntelligence(data.getRandom(), 8.0, data);
            this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
        } else {
            StudyItem chosenItem = (StudyItem)currentItems.get(this.world.f_46441_.m_188503_(currentItems.size()));
            this.worker.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)chosenItem.getItem(), 1));
            data.getCitizenSkillHandler().tryLevelUpIntelligence(data.getRandom(), 8.0 * (100.0 / (double)chosenItem.getSkillIncreasePct()), data);
            if (this.world.f_46441_.m_188503_(100) <= chosenItem.getBreakPct()) {
                data.getInventory().extractItem(chosenItem.getSlot(), 1, false);
            }
        }
        this.worker.decreaseSaturationForAction();
        this.studyPos = null;
        this.worker.queueSound(SoundEvents.f_11713_, this.worker.m_20183_().m_7494_(), 80, 15, 0.25f, 1.5f);
        this.setDelay(1200);
        return this.getState();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.STUDY;
    }
}

