/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.ai.visitor.EntityAIVisitor;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.citizen.VisitorColonyHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenChatHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenDiseaseHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenItemHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.MovementHandler;
import com.minecolonies.coremod.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisitorCitizen
extends AbstractEntityCitizen {
    private ICitizenExperienceHandler citizenExperienceHandler;
    private int citizenId = 0;
    private IWalkToProxy proxy;
    @Nullable
    private ICitizenData citizenData;
    private ICitizenChatHandler citizenChatHandler;
    private ICitizenItemHandler citizenItemHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private ICitizenDiseaseHandler citizenDiseaseHandler;

    public VisitorCitizen(EntityType<? extends AgeableMob> type, Level world) {
        super(type, world);
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.citizenChatHandler = new CitizenChatHandler(this);
        this.citizenItemHandler = new CitizenItemHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new VisitorColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenDiseaseHandler = new CitizenDiseaseHandler(this);
        this.f_21342_ = new MovementHandler((Mob)this);
        this.m_21530_();
        this.m_20340_((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        this.initTasks();
    }

    private void initTasks() {
        int priority = 0;
        this.f_21345_.m_25352_(priority, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(++priority, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(priority, (Goal)new EntityAIInteractToggleAble((Mob)this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.f_21345_.m_25352_(++priority, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(++priority, (Goal)new InteractGoal((Mob)this, EntityCitizen.class, 5.0f, 0.02f));
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
        new EntityAIVisitor(this);
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (!(damageSource.m_7639_() instanceof EntityCitizen) && super.m_6469_(damageSource, damage)) {
            if (damageSource.m_7639_() instanceof LivingEntity && damage > 1.01f) {
                Entity sourceEntity;
                IBuilding home = this.getCitizenData().getHomeBuilding();
                if (home.hasModule(TavernBuildingModule.class)) {
                    TavernBuildingModule module = (TavernBuildingModule)home.getFirstModuleOccurance(TavernBuildingModule.class);
                    for (Integer id : module.getExternalCitizens()) {
                        ICitizenData data = (ICitizenData)this.citizenColonyHandler.getColony().getVisitorManager().getCivilian(id);
                        if (data == null || !data.getEntity().isPresent() || data.getEntity().get().m_21188_() != null) continue;
                        data.getEntity().get().m_6703_((LivingEntity)damageSource.m_7639_());
                    }
                }
                if ((sourceEntity = damageSource.m_7639_()) instanceof Player) {
                    if (sourceEntity instanceof ServerPlayer) {
                        return damage <= 1.0f || this.getCitizenColonyHandler().getColony().getPermissions().hasPermission((Player)sourceEntity, Action.HURT_VISITOR);
                    }
                    IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.getCitizenColonyHandler().getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
                    return damage <= 1.0f || colonyView == null || colonyView.getPermissions().hasPermission((Player)sourceEntity, Action.HURT_VISITOR);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    @Override
    @Nullable
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public ICivilianData getCivilianData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null && data instanceof IVisitorData) {
            this.citizenData = (IVisitorData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty() {
        if (this.citizenData != null) {
            this.citizenData.markDirty();
        }
    }

    @Override
    public void setIsChild(boolean isChild) {
    }

    @Override
    public void playMoveAwaySound() {
    }

    @Override
    public IWalkToProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost());
            this.citizenData.markDirty();
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 100.0);
            this.citizenData.markDirty();
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenChatHandler getCitizenChatHandler() {
        return this.citizenChatHandler;
    }

    @Override
    public ICitizenItemHandler getCitizenItemHandler() {
        return this.citizenItemHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    @Override
    public ICitizenDiseaseHandler getCitizenDiseaseHandler() {
        return this.citizenDiseaseHandler;
    }

    @Override
    public void setCitizenDiseaseHandler(ICitizenDiseaseHandler citizenDiseaseHandler) {
        this.citizenDiseaseHandler = citizenDiseaseHandler;
    }

    @Override
    public float getRotationYaw() {
        return this.m_146908_();
    }

    @Override
    public float getRotationPitch() {
        return this.m_146909_();
    }

    @Override
    public boolean isDead() {
        return !this.m_6084_();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenItemHandler(ICitizenItemHandler citizenItemHandler) {
        this.citizenItemHandler = citizenItemHandler;
    }

    @Override
    public void setCitizenChatHandler(ICitizenChatHandler citizenChatHandler) {
        this.citizenChatHandler = citizenChatHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerCitizenInventory(id, playerInventory, this.citizenColonyHandler.getColonyId(), this.citizenId);
    }

    public InteractionResult m_21499_(Player player, @NotNull InteractionHand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)player.f_19853_.m_46472_());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return InteractionResult.FAIL;
        }
        if (!ItemStackUtils.isEmpty(player.m_21120_(hand)).booleanValue() && player.m_21120_(hand).m_41720_() instanceof NameTagItem) {
            return super.m_21499_(player, hand);
        }
        InteractionResult result = this.directPlayerInteraction(player, hand);
        if (result != null) {
            return result;
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_) {
            if (player.m_6144_()) {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(iColonyView, this.m_7755_().getString(), this.m_19879_()));
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null) {
                    MineColonies.proxy.showCitizenWindow(citizenDataView);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult directPlayerInteraction(Player player, InteractionHand hand) {
        ItemStack usedStack = player.m_21120_(hand);
        if (ItemStackUtils.ISFOOD.test(usedStack)) {
            usedStack.m_41764_(usedStack.m_41613_() - 1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                this.getCitizenData().increaseSaturation(usedStack.m_41720_().getFoodProperties(usedStack, (LivingEntity)this).m_38744_());
                this.m_5496_(SoundEvents.f_11912_, 1.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_20192_()), (Entity)this);
                this.citizenChatHandler.sendLocalizedChat("com.minecolonies.coremod.interaction.visitor.food", new Object[0]);
            }
            return InteractionResult.CONSUME;
        }
        return null;
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.citizenDataView = colonyView.getVisitor(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.f_19804_.m_135372_(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_20889_ > 0) {
            this.markDirty();
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && this.getOffsetTicks() % 20 == 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.citizenDataView = colonyView.getVisitor(this.citizenId);
                this.m_20088_().m_135381_(DATA_STYLE, (Object)colonyView.getTextureStyleId());
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.f_19797_ % 500 == 0) {
                this.m_20340_((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.citizenColonyHandler.getColony() != null && this.citizenData != null) {
            compound.m_128405_("colony", this.citizenColonyHandler.getColony().getID());
            compound.m_128405_("citizen", this.citizenData.getId());
        }
        this.citizenDiseaseHandler.write(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.citizenColonyHandler.setColonyId(compound.m_128451_("colony"));
        this.citizenId = compound.m_128451_("citizen");
        if (this.m_6142_()) {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
        }
        this.citizenDiseaseHandler.read(compound);
    }

    public void m_6667_(DamageSource cause) {
        IColony colony;
        super.m_6667_(cause);
        if (!this.f_19853_.m_5776_() && (colony = this.getCitizenColonyHandler().getColony()) != null && this.getCitizenData() != null) {
            colony.getVisitorManager().removeCivilian(this.getCitizenData());
            if (this.getCitizenData().getHomeBuilding() instanceof TavernBuildingModule) {
                TavernBuildingModule tavern = (TavernBuildingModule)((Object)this.getCitizenData().getHomeBuilding());
                tavern.setNoVisitorTime(this.f_19853_.m_213780_().m_188503_(5000) + 30000);
            }
            String deathLocation = BlockPosUtil.getString(this.m_20183_());
            MessageUtils.format("com.minecolonies.coremod.gui.tavern.visitordeath", this.getCitizenData().getName(), cause.m_19385_(), deathLocation).sendTo(colony).forManagers();
        }
    }

    protected void m_5907_() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            this.citizenItemHandler.entityDropItem(itemstack);
        }
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions) {
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions, float volume, float pitch) {
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (this.citizenColonyHandler != null) {
            this.citizenColonyHandler.onSyncDataUpdate(dataAccessor);
        }
    }
}

