/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public abstract class SimpleLootTableProvider
extends LootTableProvider {
    protected SimpleLootTableProvider(@NotNull DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected abstract void registerTables(@NotNull LootTableRegistrar var1);

    @NotNull
    protected final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        HashMap tables = new HashMap();
        this.registerTables((id, type, table) -> tables.put(id, Pair.of((Object)type, (Object)table)));
        return tables.entrySet().stream().map(entry -> SimpleLootTableProvider.make((ResourceLocation)entry.getKey(), (LootContextParamSet)((Pair)entry.getValue()).getFirst(), (LootTable.Builder)((Pair)entry.getValue()).getSecond())).collect(Collectors.toList());
    }

    private static Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet> make(@NotNull ResourceLocation id, @NotNull LootContextParamSet type, @NotNull LootTable.Builder table) {
        return Pair.of(() -> register -> register.accept(id, table), (Object)type);
    }

    protected void validate(@NotNull Map<ResourceLocation, LootTable> map, @NotNull ValidationContext validationtracker) {
        map.forEach((id, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)id, (LootTable)table));
    }

    public static LootPoolSingletonContainer.Builder<?> itemStack(@NotNull ItemStack stack) {
        if (!stack.m_41619_()) {
            LootPoolSingletonContainer.Builder builder = LootItem.m_79579_((ItemLike)stack.m_41720_());
            if (stack.m_41782_()) {
                assert (stack.m_41783_() != null);
                builder.m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)stack.m_41783_()));
            }
            if (stack.m_41613_() > 1) {
                builder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)stack.m_41613_())));
            }
            return builder;
        }
        return EmptyLootItem.m_79533_();
    }

    @FunctionalInterface
    public static interface LootTableRegistrar {
        public void register(@NotNull ResourceLocation var1, @NotNull LootContextParamSet var2, @NotNull LootTable.Builder var3);
    }
}

