/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.quests.registries.QuestRegistries;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;

public class QuestTranslationProvider
implements DataProvider {
    private final DataGenerator generator;

    public QuestTranslationProvider(@NotNull DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public String m_6055_() {
        return "QuestTranslationProvider";
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        DataGenerator.PathProvider langProvider = this.generator.m_236036_(DataGenerator.Target.RESOURCE_PACK, "lang");
        DataGenerator.PathProvider questProvider = this.generator.m_236036_(DataGenerator.Target.DATA_PACK, "quests");
        JsonObject langJson = new JsonObject();
        try (PathPackResources pack = new PathPackResources("minecolonies.src", Path.of("..", "src", "main", "resources"));){
            for (ResourceLocation questId : pack.m_214146_(PackType.SERVER_DATA, "minecolonies", "quests", id -> id.m_135815_().endsWith(".json"))) {
                JsonObject json;
                ResourceLocation questPath = new ResourceLocation(questId.m_135827_(), questId.m_135815_().replace("quests/", "").replace(".json", ""));
                String baseKey = questPath.m_135827_() + ".quests." + questPath.m_135815_().replace("/", ".");
                try (InputStreamReader reader = new InputStreamReader(pack.m_8031_(PackType.SERVER_DATA, questId));){
                    json = GsonHelper.m_13859_((Reader)reader);
                }
                this.processQuest(langJson, baseKey, json);
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)questProvider.m_236048_(questPath));
            }
        }
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)langJson, (Path)langProvider.m_236050_(new ResourceLocation("minecolonies", "quests"), "json"));
    }

    private void processQuest(JsonObject langJson, String baseKey, JsonObject json) {
        String name = json.get("name").getAsString();
        langJson.addProperty(baseKey, name);
        json.addProperty("name", baseKey);
        int objectiveCount = 0;
        for (JsonElement objectivesJson : json.get("objectives").getAsJsonArray()) {
            String objectiveKey = baseKey + ".obj" + objectiveCount;
            JsonObject objective = objectivesJson.getAsJsonObject();
            this.processObjective(langJson, objectiveKey, objective);
            ++objectiveCount;
        }
    }

    private void processObjective(JsonObject langJson, String baseKey, JsonObject json) {
        ResourceLocation type = new ResourceLocation(json.get("type").getAsString());
        if (type.equals((Object)QuestRegistries.DIALOGUE_OBJECTIVE_ID)) {
            langJson.addProperty(baseKey, json.get("text").getAsString());
            json.addProperty("text", baseKey);
            int answerCount = 0;
            for (JsonElement answerJson : json.get("options").getAsJsonArray()) {
                String answerKey = baseKey + ".answer" + answerCount;
                langJson.addProperty(answerKey, answerJson.getAsJsonObject().get("answer").getAsString());
                answerJson.getAsJsonObject().addProperty("answer", answerKey);
                JsonObject result = answerJson.getAsJsonObject().get("result").getAsJsonObject();
                this.processObjective(langJson, answerKey + ".reply", result);
                ++answerCount;
            }
        }
    }
}

