/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults.workers;

import com.google.common.collect.ImmutableMap;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.enchants.ModEnchants;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.generation.CustomRecipeAndLootTableProvider;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.SimpleLootTableProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DefaultEnchanterCraftingProvider
extends CustomRecipeAndLootTableProvider {
    private final String ENCHANTER = ModJobs.ENCHANTER_ID.m_135815_();
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int NEVER = 99;
    private static final int[] LEVEL_WEIGHTS = new int[]{0, 50, 25, 15, 5, 1};
    private static final Map<Enchantment, EnchantmentRule> RULES = ImmutableMap.builder().put((Object)Enchantments.f_44971_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44979_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44968_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44973_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44984_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44967_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44981_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44966_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44990_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44980_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44982_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44988_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44969_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44965_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44961_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44989_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44960_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44970_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44977_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44978_, (Object)new EnchantmentRule(1, 0, false)).put((Object)Enchantments.f_44983_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44986_, (Object)new EnchantmentRule(1, 1, false)).put((Object)Enchantments.f_44956_, (Object)new EnchantmentRule(1, 0, true)).put((Object)Enchantments.f_44957_, (Object)new EnchantmentRule(1, 1, true)).put((Object)Enchantments.f_44974_, (Object)new EnchantmentRule(2, 1, true)).put((Object)Enchantments.f_44955_, (Object)new EnchantmentRule(2, 1, true)).put((Object)Enchantments.f_44972_, (Object)new EnchantmentRule(2, 1, true)).put((Object)Enchantments.f_44987_, (Object)new EnchantmentRule(3, 0, true)).put((Object)Enchantments.f_44958_, (Object)new EnchantmentRule(3, 0, true)).put((Object)Enchantments.f_220304_, (Object)new EnchantmentRule(3, 0, true)).put((Object)Enchantments.f_44976_, (Object)new EnchantmentRule(3, 0, true)).put((Object)Enchantments.f_44952_, (Object)new EnchantmentRule(4, 0, true)).put((Object)Enchantments.f_44985_, (Object)new EnchantmentRule(5, 0, true)).put((Object)Enchantments.f_44962_, (Object)new EnchantmentRule(5, 0, true)).put((Object)Enchantments.f_44959_, (Object)new EnchantmentRule(5, 0, false)).put((Object)Enchantments.f_44953_, (Object)new EnchantmentRule(99, 0, false)).put((Object)Enchantments.f_44954_, (Object)new EnchantmentRule(99, 0, false)).build();
    private final List<LootTable.Builder> levels;
    private final LootTables lootTableManager;

    public DefaultEnchanterCraftingProvider(@NotNull DataGenerator generatorIn, @NotNull LootTables lootTableManager) {
        super(generatorIn);
        this.lootTableManager = lootTableManager;
        this.levels = this.buildLevels();
    }

    @NotNull
    private List<LootTable.Builder> buildLevels() {
        ArrayList<LootPool.Builder> levelPools = new ArrayList<LootPool.Builder>();
        for (int buildingLevel = 1; buildingLevel <= 5; ++buildingLevel) {
            levelPools.add(LootPool.m_79043_());
        }
        for (int enchantLevel = 1; enchantLevel <= 5; ++enchantLevel) {
            for (Map.Entry<Enchantment, EnchantmentRule> entry : RULES.entrySet()) {
                int buildingLevel;
                Enchantment enchantment = entry.getKey();
                EnchantmentRule rule = entry.getValue();
                int maxEnchantLevel = enchantment.m_6586_() + rule.bonusLevels();
                if (rule.firstLevel() > 5 || enchantLevel > maxEnchantLevel) continue;
                int firstBuildingLevel = rule.firstLevel() + enchantLevel - 1;
                int lastBuildingLevel = Math.min(firstBuildingLevel + 2, 5);
                int weight = rule.rare() ? 1 : LEVEL_WEIGHTS[Math.min(enchantLevel + rule.firstLevel() - 1, 5)];
                for (buildingLevel = firstBuildingLevel; buildingLevel <= lastBuildingLevel; ++buildingLevel) {
                    ((LootPool.Builder)levelPools.get(buildingLevel - 1)).m_79076_((LootPoolEntryContainer.Builder)this.enchantedBook(enchantment, enchantLevel).m_79707_(weight));
                }
                if (enchantLevel != maxEnchantLevel) continue;
                for (buildingLevel = lastBuildingLevel + 1; buildingLevel <= 5; ++buildingLevel) {
                    ((LootPool.Builder)levelPools.get(buildingLevel - 1)).m_79076_((LootPoolEntryContainer.Builder)this.enchantedBook(enchantment, enchantLevel).m_79707_(Math.min(weight, 5)));
                }
            }
        }
        ((LootPool.Builder)levelPools.get(2)).m_79076_((LootPoolEntryContainer.Builder)this.enchantedBook((Enchantment)ModEnchants.raiderDamage.get(), 1).m_79707_(15));
        ((LootPool.Builder)levelPools.get(3)).m_79076_((LootPoolEntryContainer.Builder)this.enchantedBook((Enchantment)ModEnchants.raiderDamage.get(), 1).m_79707_(15));
        ((LootPool.Builder)levelPools.get(4)).m_79076_((LootPoolEntryContainer.Builder)this.enchantedBook((Enchantment)ModEnchants.raiderDamage.get(), 1).m_79707_(15));
        ((LootPool.Builder)levelPools.get(4)).m_79076_((LootPoolEntryContainer.Builder)this.enchantedBook((Enchantment)ModEnchants.raiderDamage.get(), 2).m_79707_(1));
        return levelPools.stream().map(pool -> LootTable.m_79147_().m_79161_(pool)).toList();
    }

    @NotNull
    private LootPoolSingletonContainer.Builder<?> enchantedBook(Enchantment enchantment, int level) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
        EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        return SimpleLootTableProvider.itemStack(stack);
    }

    @NotNull
    public String m_6055_() {
        return "EnchanterCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        List<ItemStorage> tome = Collections.singletonList(new ItemStorage(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.ancientTome), true, true));
        for (int buildingLevel = 1; buildingLevel <= 5; ++buildingLevel) {
            CustomRecipeProvider.CustomRecipeBuilder.create(this.ENCHANTER, "custom", "tome" + buildingLevel).minBuildingLevel(buildingLevel).maxBuildingLevel(buildingLevel).inputs(tome).secondaryOutputs(Collections.singletonList(new ItemStack((ItemLike)Items.f_42690_))).lootTable(new ResourceLocation("minecolonies", "recipes/" + this.ENCHANTER + buildingLevel)).build(consumer);
        }
        CustomRecipeProvider.CustomRecipeBuilder.create(this.ENCHANTER, "custom", "scroll_tp").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.f_42516_, 3)), new ItemStorage(new ItemStack((ItemLike)Items.f_42522_)), new ItemStorage(new ItemStack((ItemLike)ModItems.buildTool.get())))).result(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollColonyTP, 3)).showTooltip(true).build(consumer);
        CustomRecipeProvider.CustomRecipeBuilder.create(this.ENCHANTER, "custom", "scroll_area_tp").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollColonyTP, 3)))).result(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollColonyAreaTP)).minBuildingLevel(2).showTooltip(true).build(consumer);
        CustomRecipeProvider.CustomRecipeBuilder.create(this.ENCHANTER, "custom", "scroll_guard_help").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollColonyTP)), new ItemStorage(new ItemStack((ItemLike)Items.f_42534_, 5)), new ItemStorage(new ItemStack((ItemLike)Items.f_42584_)), new ItemStorage(new ItemStack((ItemLike)Items.f_42516_)))).result(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollGuardHelp, 2)).minBuildingLevel(3).minResearchId(ResearchConstants.MORE_SCROLLS).showTooltip(true).build(consumer);
        CustomRecipeProvider.CustomRecipeBuilder.create(this.ENCHANTER, "custom", "scroll_highlight").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollColonyTP, 3)), new ItemStorage(new ItemStack((ItemLike)Items.f_42525_, 6)), new ItemStorage(new ItemStack((ItemLike)Items.f_42516_, 2)))).result(new ItemStack((ItemLike)com.minecolonies.api.items.ModItems.scrollHighLight, 5)).minBuildingLevel(3).minResearchId(ResearchConstants.MORE_SCROLLS).showTooltip(true).build(consumer);
    }

    @Override
    protected void registerTables(@NotNull SimpleLootTableProvider.LootTableRegistrar registrar) {
        for (int i = 0; i < this.levels.size(); ++i) {
            int buildingLevel = i + 1;
            LootTable.Builder lootTable = this.levels.get(i);
            registrar.register(new ResourceLocation("minecolonies", "recipes/" + this.ENCHANTER + buildingLevel), LootContextParamSets.f_81420_, lootTable);
        }
        this.validate(this.levels.get(4).m_79167_());
    }

    private void validate(@NotNull LootTable lootTable) {
        List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops(this.lootTableManager, lootTable);
        Collection enchantLevels = drops.stream().flatMap(drop -> drop.getItemStacks().stream()).flatMap(stack -> EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Function.identity(), BinaryOperator.maxBy(Map.Entry.comparingByValue()))).values();
        for (Map.Entry entry2 : enchantLevels) {
            EnchantmentRule rule = RULES.getOrDefault(entry2.getKey(), new EnchantmentRule(99, 0, false));
            if ((Integer)entry2.getValue() < ((Enchantment)entry2.getKey()).m_6586_() + rule.bonusLevels()) {
                Log.getLogger().warn("Enchanter max level produces {} but max is {}{}", (Object)((Enchantment)entry2.getKey()).m_44700_(((Integer)entry2.getValue()).intValue()).getString(), (Object)((Enchantment)entry2.getKey()).m_44700_(((Enchantment)entry2.getKey()).m_6586_() + rule.bonusLevels()).getString(), (Object)(rule.bonusLevels() > 0 ? " (with bonus)" : ""));
            }
            if (entry2.getKey() == ModEnchants.raiderDamage.get()) continue;
            if (((Enchantment)entry2.getKey()).m_6591_() && !rule.rare()) {
                Log.getLogger().warn("{} is a treasure enchant but isn't marked as rare?", (Object)Component.m_237115_((String)((Enchantment)entry2.getKey()).m_44704_()).getString());
            }
            if (!((Enchantment)entry2.getKey()).m_44699_().equals((Object)Enchantment.Rarity.VERY_RARE) || rule.rare()) continue;
            Log.getLogger().warn("{} is a very_rare enchant but isn't marked as rare?", (Object)Component.m_237115_((String)((Enchantment)entry2.getKey()).m_44704_()).getString());
        }
        HashSet<Enchantment> enchantments = new HashSet<Enchantment>(ForgeRegistries.ENCHANTMENTS.getValues());
        enchantLevels.stream().map(Map.Entry::getKey).forEach(enchantments::remove);
        RULES.entrySet().stream().filter(entry -> ((EnchantmentRule)entry.getValue()).firstLevel() > 5).map(Map.Entry::getKey).forEach(enchantments::remove);
        enchantments.removeIf(Enchantment::m_6589_);
        for (Enchantment enchantment : enchantments) {
            Log.getLogger().info("Enchanter does not produce {}", (Object)Component.m_237115_((String)enchantment.m_44704_()).getString());
        }
    }

    private record EnchantmentRule(int firstLevel, int bonusLevels, boolean rare) {
    }
}

