/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemClipboard
extends AbstractItemMinecolonies {
    public static final String TAG_COLONY = "colony";

    public ItemClipboard(Item.Properties properties) {
        super("clipboard", properties.m_41487_(64).m_41491_(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack clipboard = ctx.m_43723_().m_21120_(ctx.m_43724_());
        CompoundTag compound = ItemClipboard.checkForCompound(clipboard);
        BlockEntity entity = ctx.m_43725_().m_7702_(ctx.m_8083_());
        if (entity instanceof TileEntityColonyBuilding) {
            compound.m_128405_(TAG_COLONY, ((AbstractTileEntityColonyBuilding)entity).getColonyId());
            if (!ctx.m_43725_().f_46443_) {
                MessageUtils.format("com.minecolonies.coremod.item.clipboard.registered", ((TileEntityColonyBuilding)entity).getColony().getName()).sendTo(ctx.m_43723_());
            }
        } else if (ctx.m_43725_().f_46443_) {
            ItemClipboard.openWindow(compound, ctx.m_43725_(), ctx.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack clipboard = playerIn.m_21120_(hand);
        if (!worldIn.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
        }
        ItemClipboard.openWindow(ItemClipboard.checkForCompound(clipboard), worldIn, playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)clipboard);
    }

    private static CompoundTag checkForCompound(ItemStack clipboard) {
        if (!clipboard.m_41782_()) {
            clipboard.m_41751_(new CompoundTag());
        }
        return clipboard.m_41783_();
    }

    private static void openWindow(CompoundTag compound, Level world, Player player) {
        if (compound.m_128441_(TAG_COLONY)) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(compound.m_128451_(TAG_COLONY), (ResourceKey<Level>)world.m_46472_());
            if (colonyView != null) {
                MineColonies.proxy.openClipboardWindow(colonyView);
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"com.minecolonies.coremod.item.clipboard.needcolony"), true);
        }
    }
}

