/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.datalistener.QuestJsonListener;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalQuestSyncMessage
implements IMessage {
    private FriendlyByteBuf questBuffer;

    public GlobalQuestSyncMessage() {
    }

    public GlobalQuestSyncMessage(FriendlyByteBuf buf) {
        this.questBuffer = new FriendlyByteBuf(buf.copy());
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.questBuffer = new FriendlyByteBuf(buf.retain());
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeBytes((ByteBuf)this.questBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            QuestJsonListener.readGlobalQuestPackets(this.questBuffer);
        }
        this.questBuffer.release();
    }
}

