/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.client.StopMusicMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class PlayAudioMessage
implements IMessage {
    private SoundEvent soundEvent;
    private SoundSource category = SoundSource.MUSIC;

    public PlayAudioMessage() {
    }

    public PlayAudioMessage(SoundEvent event) {
        this.soundEvent = event;
    }

    public PlayAudioMessage(SoundEvent event, SoundSource category) {
        this.soundEvent = event;
        this.category = category;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.category.ordinal());
        buf.m_130130_(Registry.f_122821_.m_7447_((Object)this.soundEvent));
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.category = SoundSource.values()[buf.m_130242_()];
        this.soundEvent = (SoundEvent)Registry.f_122821_.m_7942_(buf.m_130242_());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(this.soundEvent, this.category, 1.0f, 1.0f, RandomSource.m_216327_(), 0.0, 0.0, 0.0));
    }

    public static void sendToAll(IColony col, boolean important, boolean stop, PlayAudioMessage ... messages) {
        List<Player> players = important ? col.getImportantMessageEntityPlayers() : col.getMessagePlayerEntities();
        for (Player player : players) {
            if (stop) {
                Network.getNetwork().sendToPlayer(new StopMusicMessage(), (ServerPlayer)player);
            }
            for (PlayAudioMessage pam : messages) {
                Network.getNetwork().sendToPlayer(pam, (ServerPlayer)player);
            }
        }
    }
}

