/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SaveStructureNBTMessage
implements IMessage {
    private static final String TAG_MILLIS = "millies";
    public static final String TAG_SCHEMATIC = "schematic";
    private CompoundTag compoundNBT;
    private String fileName;

    public SaveStructureNBTMessage() {
    }

    public SaveStructureNBTMessage(CompoundTag CompoundNBT, String fileName) {
        this.fileName = fileName;
        this.compoundNBT = CompoundNBT;
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        FriendlyByteBuf buffer = new FriendlyByteBuf((ByteBuf)buf);
        try (ByteBufInputStream stream = new ByteBufInputStream((ByteBuf)buffer);){
            CompoundTag wrapperCompound = NbtIo.m_128939_((InputStream)stream);
            this.compoundNBT = wrapperCompound.m_128469_(TAG_SCHEMATIC);
            this.fileName = wrapperCompound.m_128461_(TAG_MILLIS);
        }
        catch (RuntimeException e) {
            Log.getLogger().info("Structure too big to be processed", (Throwable)e);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        CompoundTag wrapperCompound = new CompoundTag();
        wrapperCompound.m_128359_(TAG_MILLIS, this.fileName);
        wrapperCompound.m_128365_(TAG_SCHEMATIC, (Tag)this.compoundNBT);
        FriendlyByteBuf buffer = new FriendlyByteBuf((ByteBuf)buf);
        try (ByteBufOutputStream stream = new ByteBufOutputStream((ByteBuf)buffer);){
            NbtIo.m_128947_((CompoundTag)wrapperCompound, (OutputStream)stream);
        }
        catch (IOException e) {
            Log.getLogger().info("Problem at retrieving structure on server.", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (this.compoundNBT != null) {
            String packName = Minecraft.m_91087_().m_91094_().m_92546_().toLowerCase(Locale.US);
            RenderingCache.getOrCreateBlueprintPreviewData((String)"blueprint").setBlueprintFuture(StructurePacks.storeBlueprint((String)packName, (CompoundTag)this.compoundNBT, (Path)Minecraft.m_91087_().f_91069_.toPath().resolve("blueprints").resolve(Minecraft.m_91087_().m_91094_().m_92546_().toLowerCase(Locale.US)).resolve("scans").resolve(this.fileName)));
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"Scan successfully saved as %s", (Object[])new Object[]{this.fileName}), false);
        }
    }
}

