/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.blocks.BlockPlantationField;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderPlantationField;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlantationFieldBuildRequestMessage
implements IMessage {
    private BlockPos pos;
    private String packName;
    private String path;
    private Rotation rotation;
    private boolean mirror;
    private ResourceKey<Level> dimension;
    private WorkOrderType workOrderType;
    private BlockPos builder;

    public PlantationFieldBuildRequestMessage() {
    }

    public PlantationFieldBuildRequestMessage(WorkOrderType workOrderType, @NotNull BlockPos pos, String packName, String path, ResourceKey<Level> dimension, Rotation rotation, boolean mirror, BlockPos builder) {
        this.workOrderType = workOrderType;
        this.pos = pos;
        this.packName = packName;
        this.path = path;
        this.dimension = dimension;
        this.rotation = rotation;
        this.mirror = mirror;
        this.builder = builder;
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.workOrderType.ordinal());
        buf.m_130064_(this.pos);
        buf.m_130070_(this.packName);
        buf.m_130070_(this.path);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeBoolean(this.mirror);
        buf.writeInt(this.rotation.ordinal());
        buf.m_130064_(this.builder);
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.workOrderType = WorkOrderType.values()[buf.readInt()];
        this.pos = buf.m_130135_();
        this.packName = buf.m_130136_(Short.MAX_VALUE);
        this.path = buf.m_130136_(Short.MAX_VALUE);
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.mirror = buf.readBoolean();
        this.rotation = Rotation.values()[buf.readInt()];
        this.builder = buf.m_130135_();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromDim(this.dimension, this.pos);
        if (colony == null) {
            return;
        }
        ServerPlayer player = ctxIn.getSender();
        if (!colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS)) {
            return;
        }
        Optional<Map.Entry> wo = colony.getWorkManager().getWorkOrders().entrySet().stream().filter(entry -> entry.getValue() instanceof WorkOrderPlantationField).filter(entry -> ((IWorkOrder)entry.getValue()).getLocation().equals((Object)this.pos)).findFirst();
        if (wo.isPresent()) {
            colony.getWorkManager().removeWorkOrder((Integer)wo.get().getKey());
            return;
        }
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)this.packName, (String)this.path), player.f_19853_, blueprint -> {
            IBuilding building;
            if (blueprint == null) {
                Log.getLogger().error(String.format("Schematic %s doesn't exist on the server.", this.path));
                return;
            }
            String[] split = this.path.split("/");
            String displayName = split[split.length - 1].replace(".blueprint", "");
            BlockState structureState = ((BlockInfo)blueprint.getBlockInfoAsMap().get(blueprint.getPrimaryBlockOffset())).getState();
            WorkOrderType type = structureState != null && !(structureState.m_60734_() instanceof BlockPlantationField) ? WorkOrderType.BUILD : this.workOrderType;
            WorkOrderPlantationField order = WorkOrderPlantationField.create(type, this.packName, this.path, WordUtils.capitalizeFully((String)displayName), this.pos, this.rotation.ordinal(), this.mirror, 0);
            if (!this.builder.equals((Object)BlockPos.f_121853_) && (building = colony.getBuildingManager().getBuilding(this.builder)) instanceof AbstractBuildingStructureBuilder) {
                order.setClaimedBy(this.builder);
            }
            colony.getWorkManager().addWorkOrder(order, false);
        }));
    }
}

