/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class BuildingHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private HiringMode mode;
    private JobEntry jobId;
    private boolean isLivingBuildingModule;

    public BuildingHiringModeMessage() {
    }

    public BuildingHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, JobEntry jobId) {
        super(building);
        this.mode = mode;
        this.jobId = jobId;
        if (jobId == null) {
            this.isLivingBuildingModule = true;
        }
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.mode = HiringMode.values()[buf.readInt()];
        this.isLivingBuildingModule = buf.readBoolean();
        if (!this.isLivingBuildingModule) {
            this.jobId = (JobEntry)buf.readRegistryIdSafe(JobEntry.class);
        }
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.mode.ordinal());
        buf.writeBoolean(this.isLivingBuildingModule);
        if (this.jobId != null) {
            buf.writeRegistryId(IMinecoloniesAPI.getInstance().getJobRegistry(), (Object)this.jobId);
        }
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        if (this.isLivingBuildingModule) {
            ((LivingBuildingModule)building.getFirstModuleOccurance(LivingBuildingModule.class)).setHiringMode(this.mode);
            building.getColony().getCitizenManager().calculateMaxCitizens();
        } else {
            ((WorkerBuildingModule)building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobId)).setHiringMode(this.mode);
        }
    }
}

