/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building.worker;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleRecipeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int recipeLocation;
    private String id;

    public ToggleRecipeMessage() {
    }

    public ToggleRecipeMessage(@NotNull IBuildingView building, int location, String id) {
        super(building);
        this.recipeLocation = location;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.recipeLocation = buf.readInt();
        this.id = buf.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.recipeLocation);
        buf.m_130070_(this.id);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)building.getModuleMatching(AbstractCraftingBuildingModule.class, m -> m.getId().equals(this.id));
        module.toggle(this.recipeLocation);
    }
}

