/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.proxy;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.crafting.CountedIngredient;
import com.minecolonies.apiimp.CommonMinecoloniesAPIImpl;
import com.minecolonies.coremod.proxy.IProxy;
import com.minecolonies.coremod.recipes.FoodIngredient;
import com.minecolonies.coremod.recipes.PlantIngredient;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.MOD)
public abstract class CommonProxy
implements IProxy {
    protected static CommonMinecoloniesAPIImpl apiImpl;
    private static final Map<String, CompoundTag> playerPropertiesData;
    public static RecipeSerializer<?> SPECIAL_REC;

    public CommonProxy() {
        apiImpl = new CommonMinecoloniesAPIImpl();
    }

    public static void storeEntityData(String name, CompoundTag compound) {
        playerPropertiesData.put(name, compound);
    }

    public static CompoundTag getEntityData(String name) {
        return playerPropertiesData.remove(name);
    }

    @SubscribeEvent
    public static void registerNewRegistries(NewRegistryEvent event) {
        apiImpl.onRegistryNewRegistry(event);
    }

    @Override
    public void setupApi() {
        MinecoloniesAPIProxy.getInstance().setApiInstance(apiImpl);
    }

    @SubscribeEvent
    public static void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((ResourceLocation)CountedIngredient.ID, (IIngredientSerializer)CountedIngredient.Serializer.getInstance());
            CraftingHelper.register((ResourceLocation)FoodIngredient.ID, (IIngredientSerializer)FoodIngredient.Serializer.getInstance());
            CraftingHelper.register((ResourceLocation)PlantIngredient.ID, (IIngredientSerializer)PlantIngredient.Serializer.getInstance());
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public void showCitizenWindow(ICitizenDataView citizen) {
    }

    @Override
    public void openSuggestionWindow(@NotNull BlockPos pos, @NotNull BlockState state, @NotNull ItemStack stack) {
    }

    @Override
    public void openBannerRallyGuardsWindow(ItemStack banner) {
    }

    @Override
    public void openClipboardWindow(IColonyView colonyView) {
    }

    @Override
    public void openResourceScrollWindow(int colonyId, BlockPos pos, BlockPos warehousePos, CompoundTag warehouseCompound) {
    }

    @Override
    @NotNull
    public RecipeBook getRecipeBookFromPlayer(@NotNull Player player) {
        return ((ServerPlayer)player).m_8952_();
    }

    @Override
    public void openDecorationControllerWindow(@NotNull BlockPos pos) {
    }

    static {
        playerPropertiesData = new HashMap<String, CompoundTag>();
    }
}

