/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.rewards;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestRewardTemplate;
import com.minecolonies.coremod.colony.CitizenData;
import net.minecraft.world.entity.player.Player;

public class SkillRewardTemplate
implements IQuestRewardTemplate {
    private final Skill skill;
    private final int target;
    private final int qty;

    public SkillRewardTemplate(Skill skill, int target, int qty) {
        this.skill = skill;
        this.target = target;
        this.qty = qty;
    }

    public static IQuestRewardTemplate createReward(JsonObject jsonObject) {
        JsonObject details = jsonObject.getAsJsonObject("details");
        int target = details.get("target").getAsInt();
        int qty = details.get("qty").getAsInt();
        Skill skill = Skill.valueOf(details.get("skill").getAsString());
        return new SkillRewardTemplate(skill, target, qty);
    }

    @Override
    public void applyReward(IColony colony, Player player, IQuestInstance colonyQuest) {
        if (this.target == 0) {
            ((CitizenData)colonyQuest.getQuestGiver()).getCitizenSkillHandler().incrementLevel(this.skill, this.qty);
        } else {
            ((CitizenData)colonyQuest.getParticipant(this.target)).getCitizenSkillHandler().incrementLevel(this.skill, this.qty);
        }
    }
}

