/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.quests.triggers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.quests.IQuestTriggerTemplate;
import com.minecolonies.api.quests.ITriggerReturnData;
import com.minecolonies.coremod.quests.triggers.CitizenTriggerReturnData;
import java.util.Collections;
import java.util.List;

public class CitizenQuestTriggerTemplate
implements IQuestTriggerTemplate {
    public final JsonElement matchTag;

    public CitizenQuestTriggerTemplate(JsonElement match) {
        this.matchTag = match;
    }

    public static CitizenQuestTriggerTemplate createStateTrigger(JsonObject questTriggerJson) {
        JsonObject subObj = questTriggerJson.get("state").getAsJsonObject();
        return new CitizenQuestTriggerTemplate(subObj.get("match"));
    }

    @Override
    public ITriggerReturnData canTriggerQuest(IColony colony) {
        List<ICitizenData> citizenDataList = colony.getCitizenManager().getCitizens();
        Collections.shuffle(citizenDataList);
        for (ICitizenData data : citizenDataList) {
            if (!IQuestTriggerTemplate.matchNbt(data.serializeNBT(), this.matchTag)) continue;
            return new CitizenTriggerReturnData(data);
        }
        return new CitizenTriggerReturnData(null);
    }
}

