/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.tiles;

import com.direwolf20.mininggadgets.client.particles.laserparticle.LaserParticleData;
import com.direwolf20.mininggadgets.common.Config;
import com.direwolf20.mininggadgets.common.blocks.ModBlocks;
import com.direwolf20.mininggadgets.common.events.ServerTickHandler;
import com.direwolf20.mininggadgets.common.items.ModItems;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.items.upgrade.Upgrade;
import com.direwolf20.mininggadgets.common.items.upgrade.UpgradeTools;
import com.direwolf20.mininggadgets.common.util.SpecialBlockActions;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class RenderBlockTileEntity
extends BlockEntity {
    private final Random rand = new Random();
    private BlockState renderBlock;
    private int priorDurability = 9999;
    private int clientPrevDurability;
    private int clientDurability;
    private int durability;
    private UUID playerUUID;
    private int originalDurability;
    private int ticksSinceMine = 0;
    private List<Upgrade> gadgetUpgrades;
    private List<ItemStack> gadgetFilters;
    private boolean gadgetIsWhitelist;
    private boolean packetReceived = false;
    private int totalAge;
    private MiningProperties.BreakTypes breakType;
    private boolean blockAllowed;

    public RenderBlockTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.RENDERBLOCK_TILE.get(), pos, state);
    }

    public static boolean blockAllowed(List<ItemStack> drops, List<ItemStack> filters, boolean isWhiteList) {
        boolean blockAllowed = false;
        for (ItemStack dropStack : drops) {
            if (filters.size() == 0) {
                return true;
            }
            boolean contains = false;
            for (ItemStack filter : filters) {
                if (!dropStack.m_41656_(filter)) continue;
                contains = true;
                break;
            }
            if (!(blockAllowed = isWhiteList && contains || !isWhiteList && !contains)) continue;
            break;
        }
        return blockAllowed;
    }

    public static <T extends BlockEntity> void ticker(Level level, BlockPos blockPos, BlockState state, T tile) {
        if (!(tile instanceof RenderBlockTileEntity)) {
            return;
        }
        RenderBlockTileEntity entity = (RenderBlockTileEntity)tile;
        ++entity.totalAge;
        if (entity.ticksSinceMine == 0) {
            entity.spawnParticle();
        }
        if (entity.f_58857_.f_46443_) {
            if (entity.playerUUID != null) {
                entity.ticksSinceMine = entity.getPlayer() != null && !entity.getPlayer().m_6117_() ? ++entity.ticksSinceMine : 0;
            }
            if (entity.packetReceived) {
                entity.priorDurability = entity.durability;
                entity.durability = entity.clientDurability;
                entity.packetReceived = false;
            } else if (entity.durability != 0) {
                entity.priorDurability = entity.durability;
            }
        }
        if (!entity.f_58857_.f_46443_) {
            if (entity.ticksSinceMine == 1) {
                entity.priorDurability = entity.durability;
                ServerTickHandler.addToList(blockPos, entity.durability, level);
            }
            if (entity.ticksSinceMine >= 10) {
                entity.priorDurability = entity.durability++;
                ServerTickHandler.addToList(blockPos, entity.durability, level);
            }
            if (entity.durability >= entity.originalDurability) {
                entity.resetBlock();
            }
            ++entity.ticksSinceMine;
        }
    }

    public BlockState getRenderBlock() {
        return this.renderBlock;
    }

    public void setRenderBlock(BlockState state) {
        this.renderBlock = state;
    }

    public MiningProperties.BreakTypes getBreakType() {
        return this.breakType;
    }

    public void setBreakType(MiningProperties.BreakTypes breakType) {
        this.breakType = breakType;
    }

    public void justSetDurability(int durability) {
        this.priorDurability = this.durability;
        this.durability = durability;
    }

    public void setDurability(int dur, ItemStack stack) {
        this.ticksSinceMine = 0;
        if (this.durability != 0) {
            this.priorDurability = this.durability;
        }
        this.durability = dur;
        if (dur <= 0) {
            this.removeBlock();
            if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FREEZING)) {
                this.freeze(stack);
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            ServerTickHandler.addToList(this.f_58858_, this.durability, this.f_58857_);
        }
    }

    private void freeze(ItemStack stack) {
        int freezeCost = (Integer)Config.UPGRADECOST_FREEZE.get() * -1;
        int energy = stack.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        if (energy == 0) {
            return;
        }
        for (Direction side : Direction.values()) {
            BlockPos sidePos = this.f_58858_.m_121945_(side);
            FluidState state = this.f_58857_.m_6425_(sidePos);
            if (state.m_76152_().m_6212_((Fluid)Fluids.f_76195_) && state.m_76152_().m_7444_(state)) {
                energy -= this.replaceBlockWithAlternative(this.f_58857_, sidePos, Blocks.f_50080_.m_49966_(), stack, freezeCost, energy);
                continue;
            }
            if (state.m_76152_().m_6212_((Fluid)Fluids.f_76193_) && state.m_76152_().m_7444_(state)) {
                energy -= this.replaceBlockWithAlternative(this.f_58857_, sidePos, Blocks.f_50354_.m_49966_(), stack, freezeCost, energy);
                continue;
            }
            if (!state.m_76152_().m_6212_((Fluid)Fluids.f_76193_) && !state.m_76152_().m_6212_((Fluid)Fluids.f_76195_) || state.m_76152_().m_7444_(state)) continue;
            energy -= this.replaceBlockWithAlternative(this.f_58857_, sidePos, Blocks.f_50652_.m_49966_(), stack, freezeCost, energy);
        }
    }

    private int replaceBlockWithAlternative(Level world, BlockPos pos, BlockState state, ItemStack stack, int costOfOperation, int remainingEnergy) {
        if (remainingEnergy < costOfOperation) {
            return 0;
        }
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> e.receiveEnergy(costOfOperation, false));
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && world.m_7702_(pos) == null) {
            world.m_46597_(pos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            return costOfOperation;
        }
        world.m_46597_(pos, state);
        return costOfOperation;
    }

    public void spawnParticle() {
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.MAGNET) && this.originalDurability > 0) {
            int PartCount = 20 / this.originalDurability;
            if (PartCount <= 1) {
                PartCount = 1;
            }
            for (int i = 0; i <= PartCount; ++i) {
                double randomPartSize = 0.125 + this.rand.nextDouble() * 0.5;
                double randomX = this.rand.nextDouble();
                double randomY = this.rand.nextDouble();
                double randomZ = this.rand.nextDouble();
                LaserParticleData data = LaserParticleData.laserparticle(this.renderBlock, (float)randomPartSize, 1.0f, 1.0f, 1.0f, 200.0f);
                this.m_58904_().m_7106_((ParticleOptions)data, (double)this.m_58899_().m_123341_() + randomX, (double)this.m_58899_().m_123342_() + randomY, (double)this.m_58899_().m_123343_() + randomZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getDurability() {
        return this.durability;
    }

    public int getOriginalDurability() {
        return this.originalDurability;
    }

    public void setOriginalDurability(int originalDurability) {
        this.originalDurability = originalDurability;
    }

    public Player getPlayer() {
        if (this.m_58904_() == null) {
            return null;
        }
        return this.m_58904_().m_46003_(this.playerUUID);
    }

    public void setPlayer(Player player) {
        this.playerUUID = player.m_20148_();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public int getTicksSinceMine() {
        return this.ticksSinceMine;
    }

    public void setTicksSinceMine(int ticksSinceMine) {
        this.ticksSinceMine = ticksSinceMine;
    }

    public int getPriorDurability() {
        return this.priorDurability;
    }

    public void setPriorDurability(int priorDurability) {
        this.priorDurability = priorDurability;
    }

    public int getClientDurability() {
        return this.clientDurability;
    }

    public void setClientDurability(int clientDurability) {
        this.clientPrevDurability = this.durability == 0 ? clientDurability : this.durability;
        this.clientDurability = clientDurability;
        this.packetReceived = true;
    }

    public List<Upgrade> getGadgetUpgrades() {
        return this.gadgetUpgrades;
    }

    public void setGadgetUpgrades(List<Upgrade> gadgetUpgrades) {
        this.gadgetUpgrades = gadgetUpgrades;
    }

    public List<ItemStack> getGadgetFilters() {
        return this.gadgetFilters;
    }

    public void setGadgetFilters(List<ItemStack> gadgetFilters) {
        this.gadgetFilters = gadgetFilters;
    }

    public boolean isGadgetIsWhitelist() {
        return this.gadgetIsWhitelist;
    }

    public void setGadgetIsWhitelist(boolean gadgetIsWhitelist) {
        this.gadgetIsWhitelist = gadgetIsWhitelist;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.renderBlock = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("renderBlock"));
        this.originalDurability = tag.m_128451_("originalDurability");
        this.priorDurability = tag.m_128451_("priorDurability");
        this.durability = tag.m_128451_("durability");
        this.ticksSinceMine = tag.m_128451_("ticksSinceMine");
        if (tag.m_128441_("playerUUID")) {
            this.playerUUID = tag.m_128342_("playerUUID");
        }
        this.gadgetUpgrades = UpgradeTools.getUpgradesFromTag(tag);
        this.breakType = MiningProperties.BreakTypes.values()[tag.m_128445_("breakType")];
        this.gadgetFilters = MiningProperties.deserializeItemStackList(tag.m_128469_("gadgetFilters"));
        this.gadgetIsWhitelist = tag.m_128471_("gadgetIsWhitelist");
        this.blockAllowed = tag.m_128471_("blockAllowed");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.renderBlock != null) {
            tag.m_128365_("renderBlock", (Tag)NbtUtils.m_129202_((BlockState)this.renderBlock));
        }
        tag.m_128405_("originalDurability", this.originalDurability);
        tag.m_128405_("priorDurability", this.priorDurability);
        tag.m_128405_("durability", this.durability);
        tag.m_128405_("ticksSinceMine", this.ticksSinceMine);
        if (this.playerUUID != null) {
            tag.m_128362_("playerUUID", this.playerUUID);
        }
        tag.m_128365_("upgrades", (Tag)UpgradeTools.setUpgradesNBT(this.gadgetUpgrades).m_128437_("upgrades", 10));
        tag.m_128344_("breakType", (byte)this.breakType.ordinal());
        tag.m_128365_("gadgetFilters", (Tag)MiningProperties.serializeItemStackList(this.getGadgetFilters()));
        tag.m_128379_("gadgetIsWhitelist", this.isGadgetIsWhitelist());
        tag.m_128379_("blockAllowed", this.blockAllowed);
    }

    private void removeBlock() {
        Optional<Upgrade> upgrade;
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.playerUUID == null) {
            return;
        }
        Player player = this.f_58857_.m_46003_(this.playerUUID);
        if (player == null) {
            return;
        }
        int silk = 0;
        int fortune = 0;
        ItemStack tempTool = new ItemStack((ItemLike)ModItems.MININGGADGET.get());
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.SILK)) {
            tempTool.m_41663_(Enchantments.f_44985_, 1);
            silk = 1;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1) && (upgrade = UpgradeTools.getUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1)).isPresent()) {
            fortune = upgrade.get().getTier();
            tempTool.m_41663_(Enchantments.f_44987_, fortune);
        }
        BlockEvent.BreakEvent breakEvent = RenderBlockTileEntity.fixForgeEventBreakBlock(this.renderBlock, player, this.f_58857_, this.f_58858_, tempTool);
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return;
        }
        List drops = Block.m_49874_((BlockState)this.renderBlock, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_, null, (Entity)player, (ItemStack)tempTool);
        if (this.blockAllowed) {
            int exp = this.renderBlock.getExpDrop((LevelReader)this.f_58857_, this.f_58857_.f_46441_, this.f_58858_, fortune, silk);
            boolean magnetMode = UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.MAGNET);
            for (ItemStack drop : drops) {
                if (drop == null) continue;
                if (magnetMode) {
                    int wasPickedUp = ForgeEventFactory.onItemPickup((ItemEntity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), drop), (Player)player);
                    if (wasPickedUp != 0 || player.m_36356_(drop)) continue;
                    Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)drop);
                    continue;
                }
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)drop);
            }
            if (magnetMode) {
                if (exp > 0) {
                    player.m_6756_(exp);
                }
            } else if (exp > 0) {
                this.renderBlock.m_60734_().m_49805_((ServerLevel)this.f_58857_, this.f_58858_, exp);
            }
            this.renderBlock.m_222967_((ServerLevel)this.f_58857_, this.f_58858_, tempTool, false);
        }
        this.f_58857_.m_46747_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this.renderBlock.m_60734_()));
        if (SpecialBlockActions.getRegister().containsKey(this.renderBlock.m_60734_())) {
            SpecialBlockActions.getRegister().get(this.renderBlock.m_60734_()).accept((Object)this.f_58857_, (Object)this.f_58858_, (Object)this.renderBlock);
        }
    }

    private static BlockEvent.BreakEvent fixForgeEventBreakBlock(BlockState state, Player player, Level world, BlockPos pos, ItemStack tool) {
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        if (state != null && ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
            int bonusLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
            int silklevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool);
            event.setExpToDrop(state.getExpDrop((LevelReader)world, world.f_46441_, pos, bonusLevel, silklevel));
        }
        return event;
    }

    private void resetBlock() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.renderBlock != null) {
                this.f_58857_.m_46597_(this.f_58858_, this.renderBlock);
            } else {
                this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public void setBlockAllowed() {
        Optional<Upgrade> upgrade;
        if (!UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.VOID_JUNK)) {
            this.blockAllowed = true;
            return;
        }
        Player player = this.f_58857_.m_46003_(this.playerUUID);
        if (player == null) {
            return;
        }
        boolean silk = false;
        int fortune = 0;
        ItemStack tempTool = new ItemStack((ItemLike)ModItems.MININGGADGET.get());
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.SILK)) {
            tempTool.m_41663_(Enchantments.f_44985_, 1);
            silk = true;
        }
        if (UpgradeTools.containsActiveUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1) && (upgrade = UpgradeTools.getUpgradeFromList(this.gadgetUpgrades, Upgrade.FORTUNE_1)).isPresent()) {
            fortune = upgrade.get().getTier();
            tempTool.m_41663_(Enchantments.f_44987_, fortune);
        }
        List drops = Block.m_49874_((BlockState)this.renderBlock, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)this.f_58858_, null, (Entity)player, (ItemStack)tempTool);
        this.blockAllowed = RenderBlockTileEntity.blockAllowed(drops, this.getGadgetFilters(), this.isGadgetIsWhitelist());
    }

    public boolean getBlockAllowed() {
        return this.blockAllowed;
    }
}

