/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.mojang.blaze3d.vertex.PoseStack;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.gui.filter.AbstractFilterContainerScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.GuiUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BulkItemFilterScreen
extends AbstractFilterContainerScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("modularrouters", "textures/gui/bulkitemfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 233;
    private ModuleTarget target;

    public BulkItemFilterScreen(AbstractSmartFilterMenu container, Inventory inventory, Component displayName) {
        super(container, inventory, displayName);
        this.f_97726_ = 176;
        this.f_97727_ = 233;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ClearButton(this.f_97735_ + 8, this.f_97736_ + 130, p -> PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.CLEAR_ALL, ((AbstractSmartFilterMenu)this.f_97732_).getLocator(), null))));
        MFLocator locator = ((AbstractSmartFilterMenu)this.f_97732_).getLocator();
        if (locator.filterSlot >= 0) {
            this.m_142416_((GuiEventListener)new BackButton(this.f_97735_ + 2, this.f_97736_ + 2, p -> this.closeGUI()));
        }
        if (locator.routerSlot >= 0 && locator.routerPos != null) {
            ItemStack moduleStack = locator.getModuleStack((Player)Minecraft.m_91087_().f_91074_);
            ModularRouterBlockEntity router = ((AbstractSmartFilterMenu)this.f_97732_).getRouter();
            CompiledModule cm = ((ModuleItem)moduleStack.m_41720_()).compile(router, moduleStack);
            this.target = cm.getEffectiveTarget(router);
            if (this.target.hasItemHandlerClientSide()) {
                this.m_142416_((GuiEventListener)new MergeButton(this.f_97735_ + 28, this.f_97736_ + 130, this.target.toString(), I18n.m_118938_((String)this.target.blockTranslationKey, (Object[])new Object[0]), p -> {
                    if (this.target != null) {
                        PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.MERGE, ((AbstractSmartFilterMenu)this.f_97732_).getLocator(), this.target.toNBT()));
                    }
                }));
                this.m_142416_((GuiEventListener)new LoadButton(this.f_97735_ + 48, this.f_97736_ + 130, this.target.toString(), I18n.m_118938_((String)this.target.blockTranslationKey, (Object[])new Object[0]), p -> {
                    if (this.target != null) {
                        PacketHandler.NETWORK.sendToServer((Object)new FilterSettingsMessage(FilterSettingsMessage.Operation.LOAD, ((AbstractSmartFilterMenu)this.f_97732_).getLocator(), this.target.toNBT()));
                    }
                }));
            }
        }
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.f_96547_.m_92883_(matrixStack, this.f_96539_, (float)this.f_97726_ / 2.0f - (float)this.f_96547_.m_92895_(this.f_96539_) / 2.0f, 8.0f, 0x404040);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        GuiUtil.bindTexture(TEXTURE_LOCATION);
        this.m_93228_(matrixStack, this.f_97735_, this.f_97736_, 0, 0, 176, 233);
    }

    public boolean m_7043_() {
        return false;
    }

    static class ClearButton
    extends Buttons.DeleteButton {
        ClearButton(int x, int y, Button.OnPress pressable) {
            super(x, y, 0, pressable);
            this.tooltip1.add(ClientUtil.xlate("modularrouters.guiText.tooltip.clearFilter", new Object[0]));
        }
    }

    static class MergeButton
    extends Buttons.AddButton {
        MergeButton(int x, int y, String locStr, String name, Button.OnPress pressable) {
            super(x, y, pressable);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.mergeFilter", name, locStr);
        }
    }

    static class LoadButton
    extends TexturedButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(144, 16);

        LoadButton(int x, int y, String locStr, String name, Button.OnPress pressable) {
            super(x, y, 16, 16, pressable);
            MiscUtil.appendMultilineText(this.tooltip1, ChatFormatting.WHITE, "modularrouters.guiText.tooltip.loadFilter", name, locStr);
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }
    }
}

