/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container.handler;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.ModuleItem;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;

public class AugmentHandler
extends ItemStackHandler {
    private final ItemStack holderStack;
    private final ModularRouterBlockEntity router;

    public AugmentHandler(ItemStack holderStack, ModularRouterBlockEntity router) {
        super(4);
        this.router = router;
        Validate.isTrue((boolean)(holderStack.m_41720_() instanceof ModuleItem), (String)"holder stack must be a module!", (Object[])new Object[0]);
        this.holderStack = holderStack;
        this.deserializeNBT(holderStack.m_41698_("modularrouters").m_128469_("Augments"));
    }

    public ItemStack getHolderStack() {
        return this.holderStack;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof AugmentItem)) {
            return false;
        }
        AugmentItem augment = (AugmentItem)item;
        if (augment.getMaxAugments((ModuleItem)this.holderStack.m_41720_()) == 0) {
            return false;
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            if (slot == i || stack.m_41720_() != this.getStackInSlot(i).m_41720_()) continue;
            return false;
        }
        return true;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AugmentItem) {
            AugmentItem augment = (AugmentItem)item;
            return augment.getMaxAugments((ModuleItem)this.holderStack.m_41720_());
        }
        return 0;
    }

    protected void onContentsChanged(int slot) {
        this.save();
    }

    private void save() {
        this.holderStack.m_41698_("modularrouters").m_128365_("Augments", (Tag)this.serializeNBT());
        if (this.router != null) {
            this.router.recompileNeeded(1);
        }
    }
}

