/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.itemsearch;

import at.ridgo8.moreoverlays.itemsearch.JeiModule;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public final class ItemUtils {
    private ItemUtils() {
    }

    public static boolean ingredientMatches(Object ingredient, ItemStack stack) {
        if (ingredient instanceof ItemStack) {
            ItemStack stack1 = (ItemStack)ingredient;
            return stack1.m_41726_(stack) && JeiModule.areItemsEqualInterpreter(stack1, stack);
        }
        if (ingredient instanceof EnchantmentInstance) {
            ListTag tags = stack.m_41720_() instanceof EnchantedBookItem ? EnchantedBookItem.m_41163_((ItemStack)stack) : stack.m_41785_();
            return ItemUtils.getEnchantmentData(tags).stream().anyMatch(ench -> ench.f_44947_.equals(((EnchantmentInstance)ingredient).f_44947_) && ench.f_44948_ == ((EnchantmentInstance)ingredient).f_44948_);
        }
        return false;
    }

    public static Collection<EnchantmentInstance> getEnchantmentData(@Nullable ListTag nbtList) {
        if (nbtList == null) {
            return Collections.emptySet();
        }
        HashSet<EnchantmentInstance> enchantments = new HashSet<EnchantmentInstance>();
        for (Tag nbt : nbtList) {
            if (!(nbt instanceof CompoundTag)) continue;
            CompoundTag nbttagcompound = (CompoundTag)nbt;
            short id = nbttagcompound.m_128448_("id");
            short level = nbttagcompound.m_128448_("lvl");
            Enchantment enchantment = Enchantment.m_44697_((int)id);
            if (enchantment == null || level <= 0) continue;
            enchantments.add(new EnchantmentInstance(enchantment, (int)level));
        }
        return enchantments;
    }

    public static boolean matchNBT(ItemStack a, ItemStack b) {
        return a.m_41782_() == b.m_41782_() && (!a.m_41782_() || a.m_41783_().equals((Object)b.m_41783_()));
    }
}

