/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.impl.GuiHorizontalScrollable;

public class ScrollBarGui
extends GuiElement {
    private final GuiHorizontalScrollable scrollable;
    private final boolean unscrollableHidden;

    public ScrollBarGui(int x, int y, int width, int height, GuiHorizontalScrollable scrollable) {
        this(x, y, width, height, scrollable, false);
    }

    public ScrollBarGui(int x, int y, int width, int height, GuiHorizontalScrollable scrollable, boolean unscrollableHidden) {
        super(x, y, width, height);
        this.scrollable = scrollable;
        this.unscrollableHidden = unscrollableHidden;
    }

    private boolean isActive() {
        return !this.unscrollableHidden || this.scrollable.getOffsetMax() > 0;
    }

    @Override
    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.isActive()) {
            super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
            this.drawBackground(matrixStack, refX + this.x, refY + this.y);
            int contentWidth = this.scrollable.getOffsetMax() + this.scrollable.getWidth();
            int handleWidth = Math.max(3, (int)((float)this.scrollable.getWidth() * 1.0f / (float)contentWidth * (float)this.width) + 1);
            int handleOffset = (int)(this.scrollable.getOffset() / (double)contentWidth * (double)this.width);
            this.drawHandle(matrixStack, refX + this.x + handleOffset, refY + this.y, handleWidth);
        }
    }

    protected void drawBackground(PoseStack matrixStack, int x, int y) {
        ScrollBarGui.drawRect(matrixStack, x, y, x + this.width, y + this.height, 0xFFFFFF, this.opacity * 0.2f);
    }

    protected void drawHandle(PoseStack matrixStack, int x, int y, int handleWidth) {
        ScrollBarGui.drawRect(matrixStack, x, y, x + handleWidth, y + this.height, 0xFFFFFF, this.opacity * 0.7f);
    }
}

