/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.block;

import com.starfish_studios.naturalist.entity.Alligator;
import com.starfish_studios.naturalist.entity.Tortoise;
import com.starfish_studios.naturalist.registry.NaturalistEntityTypes;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class TortoiseEggBlock
extends TurtleEggBlock {
    public TortoiseEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.shouldUpdateHatchLevel((Level)level)) {
            int i = (Integer)state.m_61143_((Property)f_57753_);
            if (i < 2) {
                level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_CRACK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57753_, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_HATCH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + random.m_188501_() * 0.2f);
                level.m_7471_(pos, false);
                for (int j = 0; j < (Integer)state.m_61143_((Property)f_57754_); ++j) {
                    level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    Tortoise tortoise = (Tortoise)NaturalistEntityTypes.TORTOISE.get().m_20615_((Level)level);
                    tortoise.m_146762_(-24000);
                    tortoise.m_7678_((double)pos.m_123341_() + 0.3 + (double)j * 0.2, pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
                    level.m_7967_((Entity)tortoise);
                }
            }
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.f_46443_) {
            level.m_46796_(2005, pos, 0);
        }
    }

    private boolean shouldUpdateHatchLevel(Level level) {
        return level.f_46441_.m_188503_(50) == 0;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.m_20161_()) {
            this.destroyEgg(level, state, pos, entity, 100);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, state, pos, entity, 3);
        }
        super.m_142072_(level, state, pos, entity, fallDistance);
    }

    private void destroyEgg(Level level, BlockState state, BlockPos pos, Entity entity, int chance) {
        if (!this.canDestroyEgg(level, entity)) {
            return;
        }
        if (!level.f_46443_ && level.f_46441_.m_188503_(chance) == 0 && state.m_60713_(Blocks.f_50578_)) {
            this.decreaseEggs(level, pos, state);
        }
    }

    private boolean canDestroyEgg(Level level, Entity entity) {
        if (entity instanceof Alligator) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            return entity instanceof Player || level.m_46469_().m_46207_(GameRules.f_46132_);
        }
        return false;
    }

    private void decreaseEggs(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, NaturalistSoundEvents.TORTOISE_EGG_BREAK.get(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)f_57754_);
        if (i <= 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57754_, (Comparable)Integer.valueOf(i - 1)), 2);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }
}

