/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.entity.Tortoise;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class TortoiseModel
extends AnimatedGeoModel<Tortoise> {
    public ResourceLocation getModelResource(Tortoise tortoise) {
        return new ResourceLocation("naturalist", "geo/tortoise.geo.json");
    }

    public ResourceLocation getTextureResource(Tortoise tortoise) {
        switch (tortoise.getVariant()) {
            case 1: {
                return new ResourceLocation("naturalist", "textures/entity/tortoise/green.png");
            }
            case 2: {
                return new ResourceLocation("naturalist", "textures/entity/tortoise/black.png");
            }
        }
        return new ResourceLocation("naturalist", "textures/entity/tortoise/brown.png");
    }

    public ResourceLocation getAnimationResource(Tortoise tortoise) {
        return new ResourceLocation("naturalist", "animations/tortoise.animation.json");
    }

    public void setLivingAnimations(Tortoise tortoise, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)tortoise, uniqueID, customPredicate);
        if (customPredicate == null) {
            return;
        }
        List extraDataOfType = customPredicate.getExtraDataOfType(EntityModelData.class);
        IBone head = this.getAnimationProcessor().getBone("head");
        if (tortoise.m_6162_()) {
            head.setScaleX(1.4f);
            head.setScaleY(1.4f);
            head.setScaleZ(1.4f);
        } else {
            head.setScaleX(1.0f);
            head.setScaleY(1.0f);
            head.setScaleZ(1.0f);
        }
        head.setRotationX(((EntityModelData)extraDataOfType.get((int)0)).headPitch * ((float)Math.PI / 180));
        head.setRotationY(((EntityModelData)extraDataOfType.get((int)0)).netHeadYaw * ((float)Math.PI / 180));
    }
}

