/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.divination;

import com.klikli_dev.occultism.Occultism;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Scanner {
    protected Block target;
    protected Player player;
    protected Vec3 center;
    protected float radius;
    protected float radiusSquared;
    protected BlockPos min;
    protected BlockPos max;
    protected int x;
    protected int y;
    protected int z;
    protected boolean highlightAllResults;
    private int blocksPerTick;

    public Scanner(Block target) {
        this.target = target;
    }

    public void setHighlightAllResults(boolean highlightAllResults) {
        this.highlightAllResults = highlightAllResults;
    }

    public void initialize(Player player, Vec3 center, float radius, int totalTicks) {
        this.player = player;
        this.center = center;
        this.radius = radius;
        this.radiusSquared = this.radius * this.radius;
        this.min = new BlockPos(center).m_7637_((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
        this.max = new BlockPos(center).m_7637_((double)this.radius, (double)this.radius, (double)this.radius);
        this.x = this.min.m_123341_();
        this.y = this.min.m_123342_() - 1;
        this.z = this.min.m_123343_();
        BlockPos size = this.max.m_121996_((Vec3i)this.min);
        int blockCount = (size.m_123341_() + 1) * (size.m_123342_() + 1) * (size.m_123343_() + 1);
        this.blocksPerTick = Mth.m_14167_((float)((float)blockCount / (float)totalTicks));
    }

    public void reset() {
        this.player = null;
        this.center = null;
        this.radius = 0.0f;
        this.radiusSquared = 0.0f;
        this.min = null;
        this.max = null;
    }

    public void scan(Consumer<BlockPos> resultConsumer) {
        Level level = this.player.f_19853_;
        for (int i = 0; i < this.blocksPerTick; ++i) {
            BlockPos pos;
            BlockState state;
            if (!this.nextBlock(level)) {
                return;
            }
            if (this.center.m_82531_((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > (double)this.radiusSquared || !this.isValidBlock(state = level.m_8055_(pos = new BlockPos(this.x, this.y, this.z)))) continue;
            if (this.highlightAllResults) {
                Occultism.SELECTED_BLOCK_RENDERER.selectBlock(pos, System.currentTimeMillis() + 10000L);
            }
            resultConsumer.accept(pos);
        }
    }

    public boolean nextBlock(Level level) {
        ++this.y;
        if (this.y > this.max.m_123342_() || this.y >= level.m_141928_()) {
            this.y = this.min.m_123342_();
            ++this.x;
            if (this.x > this.max.m_123341_()) {
                this.x = this.min.m_123341_();
                ++this.z;
                if (this.z > this.max.m_123343_()) {
                    this.blocksPerTick = 0;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isValidBlock(BlockState state) {
        return state.m_60734_() == this.target;
    }
}

