/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.DragonFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ThrownSwordEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class DragonRendering {

    public static class ThrownSwordRenderer
    extends ThrownItemRenderer<ThrownSwordEntity> {
        public ThrownSwordRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        public void render(ThrownSwordEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
            float ageInTicks = (float)pEntity.f_19797_ + pPartialTicks;
            pMatrixStack.m_85836_();
            pMatrixStack.m_85845_(new Quaternion(0.0f, 0.0f, ageInTicks * 20.0f, true));
            super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
        }
    }

    public static class SwordLayer
    extends RenderLayer<DragonFamiliarEntity, DragonFamiliarModel> {
        public SwordLayer(RenderLayerParent<DragonFamiliarEntity, DragonFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, DragonFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!pLivingEntity.hasSword()) {
                return;
            }
            pMatrixStack.m_85836_();
            DragonFamiliarModel model = (DragonFamiliarModel)this.m_117386_();
            model.body.m_104299_(pMatrixStack);
            model.tail1.m_104299_(pMatrixStack);
            model.tail2.m_104299_(pMatrixStack);
            model.tail3.m_104299_(pMatrixStack);
            pMatrixStack.m_85837_(0.0, 0.24, 0.32);
            pMatrixStack.m_85837_(0.0, -0.23, -0.12);
            pMatrixStack.m_85845_(new Quaternion(Mth.m_14031_((float)(pAgeInTicks / 20.0f)) * 20.0f + 130.0f, 90.0f + Mth.m_14089_((float)(pAgeInTicks / 20.0f)) * 20.0f, 0.0f, true));
            pMatrixStack.m_85837_(0.23, 0.12, 0.0);
            Minecraft.m_91087_().m_91290_().m_234586_().m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_42383_), ItemTransforms.TransformType.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
        }
    }

    public static class StickLayer
    extends RenderLayer<DragonFamiliarEntity, DragonFamiliarModel> {
        public StickLayer(RenderLayerParent<DragonFamiliarEntity, DragonFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, DragonFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!pLivingEntity.hasStick()) {
                return;
            }
            pMatrixStack.m_85836_();
            DragonFamiliarModel model = (DragonFamiliarModel)this.m_117386_();
            model.body.m_104299_(pMatrixStack);
            model.neck1.m_104299_(pMatrixStack);
            model.neck2.m_104299_(pMatrixStack);
            model.head.m_104299_(pMatrixStack);
            model.jaw.m_104299_(pMatrixStack);
            pMatrixStack.m_85837_(-0.08, -0.07, -0.15);
            pMatrixStack.m_85845_(new Quaternion(0.0f, 0.0f, -45.0f, true));
            Minecraft.m_91087_().m_91290_().m_234586_().m_109322_((LivingEntity)pLivingEntity, new ItemStack((ItemLike)Items.f_42398_), ItemTransforms.TransformType.GROUND, false, pMatrixStack, pBuffer, pPackedLight);
            pMatrixStack.m_85849_();
        }
    }
}

