/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.option;

import java.io.IOException;
import net.coderbot.iris.Iris;
import net.coderbot.iris.colorspace.ColorSpace;
import net.coderbot.iris.gui.option.ShadowDistanceOption;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class IrisVideoSettings {
    public static int shadowDistance = 32;
    private static final Component DISABLED_TOOLTIP = Component.m_237115_((String)"options.iris.shadowDistance.disabled");
    private static final Component ENABLED_TOOLTIP = Component.m_237115_((String)"options.iris.shadowDistance.enabled");
    public static ColorSpace colorSpace = ColorSpace.SRGB;
    public static final OptionInstance<Integer> RENDER_DISTANCE = new ShadowDistanceOption<Integer>("options.iris.shadowDistance", (OptionInstance.TooltipSupplierFactory<Integer>)((OptionInstance.TooltipSupplierFactory)mc -> {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        Component tooltip = pipeline != null ? (pipeline.getForcedShadowRenderDistanceChunksForDisplay().isPresent() ? DISABLED_TOOLTIP : ENABLED_TOOLTIP) : ENABLED_TOOLTIP;
        return aDouble -> Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)tooltip, 200);
    }), (OptionInstance.CaptionBasedToString<Integer>)((OptionInstance.CaptionBasedToString)(arg, d) -> {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline != null) {
            d = pipeline.getForcedShadowRenderDistanceChunksForDisplay().orElse((int)d);
        }
        if ((double)d.intValue() <= 0.0) {
            return Component.m_237110_((String)"options.generic_value", (Object[])new Object[]{Component.m_237115_((String)"options.iris.shadowDistance"), "0 (disabled)"});
        }
        return Component.m_237110_((String)"options.generic_value", (Object[])new Object[]{Component.m_237115_((String)"options.iris.shadowDistance"), Component.m_237110_((String)"options.chunks", (Object[])new Object[]{d})});
    }), (OptionInstance.ValueSet<Integer>)new OptionInstance.IntRange(0, 32), IrisVideoSettings.getOverriddenShadowDistance(shadowDistance), integer -> {
        shadowDistance = integer;
        try {
            Iris.getIrisConfig().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    });

    public static int getOverriddenShadowDistance(int base) {
        return Iris.getPipelineManager().getPipeline().map(pipeline -> pipeline.getForcedShadowRenderDistanceChunksForDisplay().orElse(base)).orElse(base);
    }

    public static boolean isShadowDistanceSliderEnabled() {
        return Iris.getPipelineManager().getPipeline().map(pipeline -> !pipeline.getForcedShadowRenderDistanceChunksForDisplay().isPresent()).orElse(true);
    }
}

