/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.contrib;

import at.petrak.paucal.api.contrib.ContributorType;
import at.petrak.relocated.nightconfig.core.AbstractConfig;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class Contributor {
    private final UUID uuid;
    private final ContributorType contributorType;
    private final AbstractConfig otherVals;

    public Contributor(UUID uuid, AbstractConfig cfg) {
        this.uuid = uuid;
        this.otherVals = cfg;
        int level = (Integer)this.otherVals.get("paucal:contributorLevel");
        boolean isDev = (Boolean)this.otherVals.get("paucal:isDev");
        boolean isCool = (Boolean)this.otherVals.get("paucal:isCool");
        this.contributorType = new ContributorType(level, isDev, isCool);
    }

    public ContributorType getContributorType() {
        return this.contributorType;
    }

    @Nullable
    public String getString(String key) {
        return (String)this.otherVals.get(key);
    }

    @Nullable
    public Integer getInt(String key) {
        Number n = (Number)this.otherVals.get(key);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Nullable
    public Float getFloat(String key) {
        Number n = (Number)this.otherVals.get(key);
        return n == null ? null : Float.valueOf(n.floatValue());
    }

    @Nullable
    public <T> T get(String key) {
        return this.otherVals.get(key);
    }

    public Set<String> allKeys() {
        return this.otherVals.valueMap().keySet();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public AbstractConfig otherVals() {
        return this.otherVals;
    }
}

