/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.common;

import at.petrak.paucal.PaucalConfig;
import at.petrak.paucal.api.PaucalAPI;
import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.relocated.nightconfig.core.AbstractConfig;
import at.petrak.relocated.nightconfig.core.CommentedConfig;
import at.petrak.relocated.nightconfig.core.UnmodifiableCommentedConfig;
import at.petrak.relocated.nightconfig.toml.TomlParser;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.DefaultUncaughtExceptionHandler;
import org.jetbrains.annotations.Nullable;

public class Contributors {
    private static Map<UUID, Contributor> CONTRIBUTORS = Object2ObjectMaps.emptyMap();
    private static boolean startedLoading = false;

    @Nullable
    public static Contributor getContributor(UUID uuid) {
        return CONTRIBUTORS.get(uuid);
    }

    public static void loadContributors() {
        if (!startedLoading) {
            startedLoading = true;
            if (!PaucalConfig.common().loadContributors()) {
                PaucalAPI.LOGGER.info("Contributors disabled in the config!");
                return;
            }
            Contributors.forceLoadContributors();
        }
    }

    public static void forceLoadContributors() {
        Thread thread = new Thread(Contributors::fetchAndPopulate);
        thread.setName("PAUCAL Contributors Loading Thread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(PaucalAPI.LOGGER));
        thread.start();
    }

    private static void fetchAndPopulate() {
        CONTRIBUTORS = Contributors.fetch();
        PaucalAPI.LOGGER.info("Successfully loaded {} contributors", (Object)CONTRIBUTORS.size());
    }

    public static Map<UUID, Contributor> fetch() {
        UnmodifiableCommentedConfig config;
        try {
            URL url = new URL("https://raw.githubusercontent.com/gamma-delta/contributors/main/paucal.toml");
            config = ((CommentedConfig)new TomlParser().parse(url)).unmodifiable();
        }
        catch (IOException exn) {
            PaucalAPI.LOGGER.warn("Couldn't load contributors from Github: {}", (Object)exn.getMessage());
            PaucalAPI.LOGGER.warn("Oh well :(");
            return Object2ObjectMaps.emptyMap();
        }
        HashMap<UUID, Contributor> out = new HashMap<UUID, Contributor>();
        for (UnmodifiableCommentedConfig.Entry entry : config.entrySet()) {
            try {
                AbstractConfig rawEntry = (AbstractConfig)entry.getValue();
                UUID uuid = UUID.fromString(entry.getKey());
                Contributor contributor = new Contributor(uuid, rawEntry);
                out.put(uuid, contributor);
            }
            catch (Exception exn) {
                PaucalAPI.LOGGER.warn("Exception when loading contributor '{}': {}", (Object)entry.getKey(), (Object)exn.getMessage());
            }
        }
        return out;
    }
}

