/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import java.lang.reflect.Field;
import java.util.Objects;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.DefinitionError;
import net.roguelogix.phosphophyllite.config.spec.SpecNumberNode;
import net.roguelogix.phosphophyllite.config.spec.SpecObjectNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.TriConsumer;

@NonnullDefault
public class SpecIntegralNode
extends SpecNumberNode {
    private final IntType type;
    public final long lowerBound;
    public final long upperBound;
    public final long defaultValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SpecIntegralNode(SpecObjectNode parent, Field field, ConfigOptionsDefaults defaults) {
        super(parent, field, defaults);
        ConfigValue annotation = field.getAnnotation(ConfigValue.class);
        String range = annotation.range().trim().substring(1, annotation.range().length() - 1).trim();
        String[] bounds = range.split(",");
        String lowerBoundStr = "";
        String upperBoundStr = "";
        if (bounds.length == 2) {
            lowerBoundStr = bounds[0].trim();
            upperBoundStr = bounds[1].trim();
        } else {
            if (range.length() == 0) {
                throw new DefinitionError("Incomplete range given");
            }
            if (range.length() != 1) {
                if (bounds.length != 1) {
                    throw new DefinitionError("Incomplete range given");
                }
                if (range.charAt(0) == ',') {
                    upperBoundStr = bounds[0];
                } else {
                    if (range.charAt(range.length() - 1) != ',') throw new DefinitionError("Incomplete range given");
                    lowerBoundStr = bounds[0];
                }
            } else if (range.charAt(0) != ',') {
                throw new DefinitionError("Incomplete range given");
            }
        }
        long lowerBound = Long.MIN_VALUE;
        if (lowerBoundStr.length() != 0) {
            lowerBound = Long.parseLong(lowerBoundStr);
        }
        long upperBound = Long.MAX_VALUE;
        if (upperBoundStr.length() != 0) {
            upperBound = Long.parseLong(upperBoundStr);
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.defaultValue = ((Number)this.currentValueObject()).longValue();
        this.type = IntType.fromClass(field.getType());
    }

    @Override
    public String defaultValueAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public String currentValueAsString() {
        return this.currentValueObject().toString();
    }

    @Override
    public void writeFromString(String string) {
        this.type.write(this.field, this.parent.object(), Long.parseLong(string));
    }

    @Override
    public boolean isValueValid(String valueString) {
        long val;
        try {
            val = Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return this.isValueValid(val);
    }

    public boolean isValueValid(long val) {
        if (this.lowerInclusive && val != this.lowerBound || val < this.lowerBound) {
            return false;
        }
        if (this.upperInclusive && val != this.upperBound || val > this.upperBound) {
            return false;
        }
        return false;
    }

    @Override
    public String lowerBoundAsString() {
        return String.valueOf(this.lowerBound);
    }

    @Override
    public String upperBoundAsString() {
        return String.valueOf(this.upperBound);
    }

    @Override
    public void writeDefault() {
        this.type.write(this.field, this.parent.object(), this.defaultValue);
    }

    @Override
    public Element generateDefaultElement() {
        return new Element(Element.Type.Number, this.generateComment(), this.name, this.defaultValue);
    }

    @Override
    public Element generateCurrentElement() {
        return new Element(Element.Type.Number, this.generateComment(), this.name, this.currentValueObject());
    }

    @Override
    public Element generateSyncElement() {
        return new Element(Element.Type.Number, null, this.name, this.currentValueObject());
    }

    @Override
    public String generateComment() {
        StringBuilder comment = new StringBuilder(this.baseComment);
        ConfigValue fieldAnnotation = this.field.getAnnotation(ConfigValue.class);
        if (!fieldAnnotation.range().equals("(,)")) {
            if (comment.length() != 0) {
                comment.append('\n');
            }
            comment.append("Valid range: ").append(fieldAnnotation.range());
        }
        if (comment.length() != 0) {
            comment.append('\n');
        }
        comment.append("Default: ");
        comment.append(this.defaultValue);
        return comment.toString();
    }

    @Override
    public Element correctToValidState(Element element) {
        if (element.type != Element.Type.Number || !(element.value instanceof Number)) {
            return this.generateDefaultElement();
        }
        if (this.isValueValid(element.asLong())) {
            return element;
        }
        long val = element.asLong();
        val = Math.min(Math.max(val, this.lowerBound), this.upperBound);
        if (!this.lowerInclusive && val == this.lowerBound) {
            ++val;
        }
        if (!this.upperInclusive && val == this.upperBound) {
            --val;
        }
        return new Element(Element.Type.Number, Objects.requireNonNull(this.generateDefaultElement()).comment, this.name, val);
    }

    @Override
    public void writeElement(Element element) {
        this.type.write(this.field, this.parent.object(), element.asLong());
    }

    public static enum IntType {
        BYTE((f, o, l) -> f.setShort(o, l.byteValue())),
        SHORT((f, o, l) -> f.setShort(o, l.shortValue())),
        INT((f, o, l) -> f.setInt(o, l.intValue())),
        LONG(Field::setLong);

        private final TriConsumer.WithException<Field, Object, Long, IllegalAccessException> writeFunction;

        private IntType(TriConsumer.WithException<Field, Object, Long, IllegalAccessException> writeFunction) {
            this.writeFunction = writeFunction;
        }

        public void write(Field field, Object obj, long val) {
            try {
                this.writeFunction.accept(field, obj, val);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public static IntType fromClass(Class<?> clazz) {
            if (clazz == Long.class || clazz == Long.TYPE) {
                return LONG;
            }
            if (clazz == Integer.class || clazz == Integer.TYPE) {
                return INT;
            }
            if (clazz == Short.class || clazz == Short.TYPE) {
                return SHORT;
            }
            if (clazz == Byte.class || clazz == Byte.TYPE) {
                return BYTE;
            }
            throw new IllegalArgumentException();
        }
    }
}

