/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock2.common;

import javax.annotation.Nonnull;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.multiblock2.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock2.modular.IModularMultiblockController;
import net.roguelogix.phosphophyllite.multiblock2.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock2.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock2.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.multiblock2.validated.IValidatedMultiblockControllerModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public interface IEventMultiblock<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IModularMultiblockController<TileType, BlockType, ControllerType> {

    public static final class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends MultiblockControllerModule<TileType, BlockType, ControllerType>
    implements IValidatedMultiblockControllerModule {
        FastArraySet<AssemblyStateTransition> assemblyStateTransitionTiles = new FastArraySet();

        @OnModLoad
        public static void register() {
            MultiblockControllerModuleRegistry.registerModule(IEventMultiblock.class, Module::new);
        }

        public Module(IModularMultiblockController<TileType, BlockType, ControllerType> controller) {
            super(controller);
        }

        @Override
        public void onPartAdded(@Nonnull TileType tile) {
            if (tile instanceof AssemblyStateTransition) {
                AssemblyStateTransition iface = (AssemblyStateTransition)tile;
                this.assemblyStateTransitionTiles.add(iface);
            }
        }

        @Override
        public void onPartRemoved(@Nonnull TileType tile) {
            if (tile instanceof AssemblyStateTransition) {
                AssemblyStateTransition iface = (AssemblyStateTransition)tile;
                this.assemblyStateTransitionTiles.remove(iface);
            }
        }

        @Override
        public void onStateTransition(IValidatedMultiblock.AssemblyState oldAssemblyState, IValidatedMultiblock.AssemblyState newAssemblyState) {
            for (AssemblyStateTransition element : this.assemblyStateTransitionTiles.elements()) {
                element.onAssemblyStateTransition(oldAssemblyState, newAssemblyState);
            }
        }
    }

    public static interface AssemblyStateTransition {
        public void onAssemblyStateTransition(IValidatedMultiblock.AssemblyState var1, IValidatedMultiblock.AssemblyState var2);

        public static interface OnAssembly
        extends AssemblyStateTransition {
            @Override
            default public void onAssemblyStateTransition(IValidatedMultiblock.AssemblyState oldState, IValidatedMultiblock.AssemblyState newState) {
                if (newState == IValidatedMultiblock.AssemblyState.ASSEMBLED) {
                    this.onAssembly();
                }
            }

            public void onAssembly();
        }
    }
}

