/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock2.rectangular;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.roguelogix.phosphophyllite.multiblock2.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock2.ValidationException;
import net.roguelogix.phosphophyllite.multiblock2.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock2.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock2.rectangular.IRectangularMultiblockBlock;
import net.roguelogix.phosphophyllite.multiblock2.rectangular.InvalidBlock;
import net.roguelogix.phosphophyllite.multiblock2.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.multiblock2.validated.IValidatedMultiblockControllerModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3i;
import net.roguelogix.phosphophyllite.repack.org.joml.Vector3ic;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;

@NonnullDefault
public interface IRectangularMultiblock<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IValidatedMultiblock<TileType, BlockType, ControllerType> {
    @Nullable
    default public Vector3ic minSize() {
        return null;
    }

    @Nullable
    default public Vector3ic maxSize() {
        return null;
    }

    default public boolean orientationAgnostic() {
        return true;
    }

    default public boolean xzAgnostic() {
        return true;
    }

    default public boolean cornerSpecificValidation() {
        return true;
    }

    default public boolean frameSpecificValidation() {
        return true;
    }

    default public void rectangularValidationStarted() {
    }

    default public void rectangularBlockValidated(Block block) {
    }

    default public boolean allowedInteriorBlock(Block block) {
        return false;
    }

    public static final class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends MultiblockControllerModule<TileType, BlockType, ControllerType>
    implements IValidatedMultiblockControllerModule {
        private boolean cornerSpecificValidation;
        private boolean frameSpecificValidation;
        private int foundMultiblockBlocks;

        @OnModLoad
        public static void register() {
            MultiblockControllerModuleRegistry.registerModule(IRectangularMultiblock.class, Module::new);
        }

        public Module(IRectangularMultiblock<TileType, BlockType, ControllerType> controller) {
            super(controller);
        }

        @Override
        public void validateStage1() throws ValidationException {
            Vector3ic min = this.controller.min();
            Vector3ic max = this.controller.max();
            int minX = min.x();
            int minY = min.y();
            int minZ = min.z();
            int maxX = max.x();
            int maxY = max.y();
            int maxZ = max.z();
            Vector3i[] allowedOrientations = new Vector3i[((IRectangularMultiblock)((Object)this.controller)).orientationAgnostic() ? 6 : (((IRectangularMultiblock)((Object)this.controller)).xzAgnostic() ? 2 : 1)];
            if (((IRectangularMultiblock)((Object)this.controller)).orientationAgnostic()) {
                allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
                allowedOrientations[1] = new Vector3i(maxX - minX + 1, maxZ - minZ + 1, maxY - minY + 1);
                allowedOrientations[2] = new Vector3i(maxY - minY + 1, maxX - minX + 1, maxZ - minZ + 1);
                allowedOrientations[3] = new Vector3i(maxY - minY + 1, maxZ - minZ + 1, maxX - minX + 1);
                allowedOrientations[4] = new Vector3i(maxZ - minZ + 1, maxX - minX + 1, maxY - minY + 1);
                allowedOrientations[5] = new Vector3i(maxZ - minZ + 1, maxY - minY + 1, maxX - minX + 1);
            } else if (((IRectangularMultiblock)((Object)this.controller)).xzAgnostic()) {
                allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
                allowedOrientations[1] = new Vector3i(maxZ - minZ + 1, maxY - minY + 1, maxX - minX + 1);
            } else {
                allowedOrientations[0] = new Vector3i(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1);
            }
            Vector3ic minSize = ((IRectangularMultiblock)((Object)this.controller)).minSize();
            Vector3ic maxSize = ((IRectangularMultiblock)((Object)this.controller)).maxSize();
            Vector3i dimensions = null;
            for (Vector3i allowedOrientation : allowedOrientations) {
                if (minSize != null && (allowedOrientation.x < minSize.x() || allowedOrientation.y < minSize.y() || allowedOrientation.z < minSize.z()) || maxSize != null && (allowedOrientation.x > maxSize.x() || allowedOrientation.y > maxSize.y() || allowedOrientation.z > maxSize.z())) continue;
                dimensions = allowedOrientation;
                break;
            }
            if (dimensions == null) {
                Vector3ic minSizenn = minSize != null ? minSize : new Vector3i();
                Vector3ic maxSizenn = maxSize != null ? maxSize : new Vector3i();
                throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.phosphophyllite.dimensions", (Object[])new Object[]{allowedOrientations[0].x, allowedOrientations[0].y, allowedOrientations[0].z, minSizenn.x(), minSizenn.y(), minSizenn.z(), maxSizenn.x(), maxSizenn.y(), maxSizenn.z()}));
            }
        }

        @Override
        public void validateStage2() throws ValidationException {
            ((IRectangularMultiblock)((Object)this.controller)).rectangularValidationStarted();
            this.cornerSpecificValidation = ((IRectangularMultiblock)((Object)this.controller)).cornerSpecificValidation();
            this.frameSpecificValidation = ((IRectangularMultiblock)((Object)this.controller)).frameSpecificValidation();
            this.foundMultiblockBlocks = 0;
            Util.chunkCachedBlockStateIteration(this.controller.min(), this.controller.max(), this.controller.level, this::blockValidation);
            if (this.foundMultiblockBlocks != this.controller.blocks.size()) {
                throw new ValidationException((Component)Component.m_237110_((String)"multiblock.error.phosphophyllite.mismatched_block_count", (Object[])new Object[]{this.foundMultiblockBlocks, this.controller.blocks.size()}));
            }
        }

        private void blockValidation(BlockState blockState, Vector3ic pos) throws ValidationException {
            Vector3ic min = this.controller.min();
            Vector3ic max = this.controller.max();
            int minX = min.x();
            int minY = min.y();
            int minZ = min.z();
            int maxX = max.x();
            int maxY = max.y();
            int maxZ = max.z();
            Block block = blockState.m_60734_();
            int extremes = 0;
            if (pos.x() == minX || pos.x() == maxX) {
                ++extremes;
            }
            if (pos.y() == minY || pos.y() == maxY) {
                ++extremes;
            }
            if (pos.z() == minZ || pos.z() == maxZ) {
                ++extremes;
            }
            switch (extremes) {
                case 3: {
                    if (this.cornerSpecificValidation) {
                        if (block instanceof IRectangularMultiblockBlock && this.controller.blockTypeValidator.test(block) && ((IRectangularMultiblockBlock)block).isGoodForCorner()) {
                            ++this.foundMultiblockBlocks;
                            break;
                        }
                        throw new InvalidBlock(block, pos, "corner");
                    }
                }
                case 2: {
                    if (this.frameSpecificValidation) {
                        if (block instanceof IRectangularMultiblockBlock && this.controller.blockTypeValidator.test(block) && ((IRectangularMultiblockBlock)block).isGoodForFrame()) {
                            ++this.foundMultiblockBlocks;
                            break;
                        }
                        throw new InvalidBlock(block, pos, "frame");
                    }
                }
                case 1: {
                    if (block instanceof IRectangularMultiblockBlock && this.controller.blockTypeValidator.test(block) && ((IRectangularMultiblockBlock)block).isGoodForExterior()) {
                        ++this.foundMultiblockBlocks;
                        break;
                    }
                    throw new InvalidBlock(block, pos, "exterior");
                }
                default: {
                    if (block instanceof IRectangularMultiblockBlock && this.controller.blockTypeValidator.test(block)) {
                        if (((IRectangularMultiblockBlock)block).isGoodForInterior()) {
                            ++this.foundMultiblockBlocks;
                            break;
                        }
                        throw new InvalidBlock(block, pos, "interior");
                    }
                    if (((IRectangularMultiblock)((Object)this.controller)).allowedInteriorBlock(block)) break;
                    throw new InvalidBlock(block, pos, "interior");
                }
            }
            ((IRectangularMultiblock)((Object)this.controller)).rectangularBlockValidated(block);
        }
    }
}

