/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.registry;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.roguelogix.phosphophyllite.config.ConfigManager;
import net.roguelogix.phosphophyllite.registry.ClientOnly;
import net.roguelogix.phosphophyllite.registry.ContainerSupplier;
import net.roguelogix.phosphophyllite.registry.CreativeTabBlock;
import net.roguelogix.phosphophyllite.registry.IgnoreRegistration;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.registry.PhosphophylliteFluid;
import net.roguelogix.phosphophyllite.registry.RegisterBlock;
import net.roguelogix.phosphophyllite.registry.RegisterCapability;
import net.roguelogix.phosphophyllite.registry.RegisterConfig;
import net.roguelogix.phosphophyllite.registry.RegisterContainer;
import net.roguelogix.phosphophyllite.registry.RegisterFluid;
import net.roguelogix.phosphophyllite.registry.RegisterItem;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.registry.SideOnly;
import net.roguelogix.phosphophyllite.threading.Event;
import net.roguelogix.phosphophyllite.threading.WorkQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Registry {
    private final Logger LOGGER;
    private final WorkQueue blockRegistrationQueue = new WorkQueue();
    private RegisterEvent.RegisterHelper<Block> blockRegistryEvent;
    private final WorkQueue itemRegistrationQueue = new WorkQueue();
    private RegisterEvent.RegisterHelper<Item> itemRegistryEvent;
    private final CreativeModeTab itemGroup;
    private Item itemGroupItem = Items.f_41905_;
    private final WorkQueue fluidRegistrationQueue = new WorkQueue();
    private RegisterEvent.RegisterHelper<Fluid> fluidRegistryEvent;
    private final WorkQueue fluidTypeRegistrationQueue = new WorkQueue();
    private RegisterEvent.RegisterHelper<FluidType> fluidTypeRegistryEvent;
    private final WorkQueue containerRegistrationQueue = new WorkQueue();
    private RegisterEvent.RegisterHelper<MenuType<?>> containerRegistryEvent;
    private final WorkQueue tileRegistrationQueue = new WorkQueue();
    private RegisterEvent.RegisterHelper<BlockEntityType<?>> tileRegistryEvent;
    private final Map<Class<?>, LinkedList<Block>> tileBlocks = new HashMap();
    private final WorkQueue registerCapabilityQueue = new WorkQueue();
    private RegisterCapabilitiesEvent registerCapabilitiesEvent;
    private final WorkQueue clientSetupQueue = new WorkQueue();
    private FMLClientSetupEvent clientSetupEvent;
    private final WorkQueue commonSetupQueue = new WorkQueue();
    private FMLCommonSetupEvent commonSetupEvent;
    private final Map<String, AnnotationHandler> annotationMap = new Object2ObjectOpenHashMap();
    private static final Field itemCreativeModeTabField;
    private static final Field tileProducerTYPEField;

    public Registry() {
        this.annotationMap.put(RegisterBlock.class.getName(), this::registerBlockAnnotation);
        this.annotationMap.put(RegisterItem.class.getName(), this::registerItemAnnotation);
        this.annotationMap.put(RegisterFluid.class.getName(), this::registerFluidAnnotation);
        this.annotationMap.put(RegisterContainer.class.getName(), this::registerContainerAnnotation);
        this.annotationMap.put(RegisterTile.class.getName(), this::registerTileAnnotation);
        this.annotationMap.put(RegisterCapability.class.getName(), this::registerCapabilityAnnotation);
        String callerClass = new Exception().getStackTrace()[1].getClassName();
        String callerPackage = callerClass.substring(0, callerClass.lastIndexOf("."));
        String modNamespace = callerPackage.substring(callerPackage.lastIndexOf(".") + 1);
        ModFileScanData modFileScanData = FMLLoader.getLoadingModList().getModFileById(modNamespace).getFile().getScanResult();
        this.LOGGER = LogManager.getLogger((String)("Phosphophyllite/Registry/" + modNamespace));
        this.itemGroup = new CreativeModeTab(modNamespace){

            @Nonnull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)Registry.this.itemGroupItem);
            }

            public void m_6151_(@Nonnull NonNullList<ItemStack> items) {
                super.m_6151_(items);
                items.sort((o1, o2) -> o1.m_41611_().getString().compareToIgnoreCase(o2.m_41611_().getString()));
            }
        };
        Object2ObjectOpenHashMap onModLoadMap = new Object2ObjectOpenHashMap();
        onModLoadMap.put(OnModLoad.class.getName(), this::onModLoadAnnotation);
        Object2ObjectOpenHashMap registerConfigMap = new Object2ObjectOpenHashMap();
        registerConfigMap.put(RegisterConfig.class.getName(), this::registerConfigAnnotation);
        this.handleAnnotationTypes(modFileScanData, callerPackage, modNamespace, (Map<String, AnnotationHandler>)registerConfigMap, true);
        this.handleAnnotationTypes(modFileScanData, callerPackage, modNamespace, (Map<String, AnnotationHandler>)onModLoadMap, true);
        this.handleAnnotationTypes(modFileScanData, callerPackage, modNamespace, this.annotationMap, false);
        IEventBus ModBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBus.addListener(this::registerEvent);
        ModBus.addListener(this::commonSetupEventHandler);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ModBus.addListener(this::clientSetupEventHandler);
        }
    }

    private void handleAnnotationTypes(ModFileScanData modFileScanData, String callerPackage, String modNamespace, Map<String, AnnotationHandler> annotations, boolean requiredCheck) {
        for (ModFileScanData.AnnotationData annotation : modFileScanData.getAnnotations()) {
            String className;
            String annotationClassName = annotation.annotationType().getClassName();
            AnnotationHandler handler = annotations.get(annotationClassName);
            if (handler == null || !(className = annotation.clazz().getClassName()).startsWith(callerPackage)) continue;
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Attempting to handle " + annotationClassName + " in class " + className + " on member " + annotation.memberName());
            }
            try {
                SideOnly sideOnly;
                Class<?> clazz = Registry.class.getClassLoader().loadClass(className);
                if (clazz.isAnnotationPresent(ClientOnly.class) && !FMLEnvironment.dist.isClient() || clazz.isAnnotationPresent(SideOnly.class) && (sideOnly = clazz.getAnnotation(SideOnly.class)).value() != FMLEnvironment.dist) continue;
                handler.run(modNamespace, clazz, annotation.memberName());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                Object isRequired;
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Failed to handle required annotation " + annotation.annotationType().getClassName() + " in class " + className + " on member " + annotation.memberName() + " with error " + e);
                }
                if (!requiredCheck || !((isRequired = annotation.annotationData().get("required")) instanceof Boolean) || !((Boolean)isRequired).booleanValue()) continue;
                e.printStackTrace();
                throw new IllegalStateException("Failed to handle required annotation " + annotation.annotationType().getClassName() + " in class " + className);
            }
        }
    }

    private void registerEvent(RegisterEvent registerEvent) {
        registerEvent.register(net.minecraft.core.Registry.f_122901_, this::blockRegistration);
        registerEvent.register(net.minecraft.core.Registry.f_122904_, this::itemRegistration);
        registerEvent.register(net.minecraft.core.Registry.f_122899_, this::fluidRegistration);
        registerEvent.register(ForgeRegistries.Keys.FLUID_TYPES, this::fluidTypeRegistration);
        registerEvent.register(net.minecraft.core.Registry.f_122913_, this::containerRegistration);
        registerEvent.register(net.minecraft.core.Registry.f_122907_, this::tileEntityRegistration);
    }

    private void blockRegistration(RegisterEvent.RegisterHelper<Block> event) {
        this.blockRegistryEvent = event;
        this.blockRegistrationQueue.runAll();
        this.blockRegistryEvent = null;
    }

    private void itemRegistration(RegisterEvent.RegisterHelper<Item> event) {
        this.itemRegistryEvent = event;
        this.itemRegistrationQueue.runAll();
        this.itemRegistryEvent = null;
    }

    private void fluidRegistration(RegisterEvent.RegisterHelper<Fluid> event) {
        this.fluidRegistryEvent = event;
        this.fluidRegistrationQueue.runAll();
        this.fluidRegistryEvent = null;
    }

    private void fluidTypeRegistration(RegisterEvent.RegisterHelper<FluidType> event) {
        this.fluidTypeRegistryEvent = event;
        this.fluidTypeRegistrationQueue.runAll();
        this.fluidTypeRegistryEvent = null;
    }

    private void containerRegistration(RegisterEvent.RegisterHelper<MenuType<?>> containerTypeRegistryEvent) {
        this.containerRegistryEvent = containerTypeRegistryEvent;
        this.containerRegistrationQueue.runAll();
        this.containerRegistryEvent = null;
    }

    private void tileEntityRegistration(RegisterEvent.RegisterHelper<BlockEntityType<?>> tileEntityTypeRegister) {
        this.tileRegistryEvent = tileEntityTypeRegister;
        this.tileRegistrationQueue.runAll();
        this.tileRegistryEvent = null;
    }

    private void clientSetupEventHandler(FMLClientSetupEvent event) {
        this.clientSetupEvent = event;
        this.clientSetupQueue.runAll();
        this.clientSetupEvent = null;
    }

    private void commonSetupEventHandler(FMLCommonSetupEvent event) {
        this.commonSetupEvent = event;
        this.commonSetupQueue.runAll();
        this.commonSetupEvent = null;
    }

    private void registerBlockAnnotation(String modNamespace, Class<?> blockClazz, String memberName) {
        if (blockClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Registration of block at " + memberName + " in " + blockClazz.getName() + " ignored");
            }
            return;
        }
        this.blockRegistrationQueue.enqueue(() -> {
            RegisterBlock annotation;
            Block block;
            try {
                Field field = blockClazz.getDeclaredField(memberName);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Registration of block at " + memberName + " in " + blockClazz.getName() + " ignored");
                    }
                    return;
                }
                if (!Modifier.isStatic(field.getModifiers())) {
                    this.LOGGER.warn("Non-static block instance variable " + memberName + " in " + blockClazz.getSimpleName());
                    return;
                }
                field.setAccessible(true);
                block = (Block)field.get(null);
                annotation = field.getAnnotation(RegisterBlock.class);
                if (!Modifier.isFinal(field.getModifiers())) {
                    this.LOGGER.warn("Non-final block instance variable " + memberName + " in " + blockClazz.getSimpleName());
                }
            }
            catch (NoSuchFieldException e) {
                this.LOGGER.error("Unable to find block field for block " + memberName + " in " + blockClazz.getSimpleName());
                return;
            }
            catch (IllegalAccessException e) {
                this.LOGGER.error("Unable to access block field for block " + memberName + " in " + blockClazz.getSimpleName());
                return;
            }
            if (block == null) {
                this.LOGGER.warn("Null block instance variable " + memberName + " in " + blockClazz.getSimpleName());
                return;
            }
            String modid = annotation.modid();
            if (modid.equals("")) {
                modid = modNamespace;
            }
            String name = annotation.name();
            if (modid.equals("")) {
                this.LOGGER.error("Unable to register block without a name from class " + blockClazz.getSimpleName());
                return;
            }
            if (!Block.class.isAssignableFrom(blockClazz)) {
                this.LOGGER.error("Attempt to register block from class not extended from Block. " + blockClazz.getSimpleName());
                return;
            }
            String registryName = modid + ":" + name;
            if (annotation.tileEntityClass() != BlockEntity.class) {
                this.tileBlocks.computeIfAbsent(annotation.tileEntityClass(), k -> new LinkedList()).add(block);
            }
            this.blockRegistryEvent.register(new ResourceLocation(registryName), (Object)block);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Block registered: " + registryName);
            }
            if (FMLEnvironment.dist.isClient()) {
                this.clientSetupQueue.enqueue(() -> {
                    RenderType renderType = null;
                    for (Method declaredMethod : blockClazz.getDeclaredMethods()) {
                        if (!declaredMethod.isAnnotationPresent(RegisterBlock.RenderLayer.class)) continue;
                        if (Modifier.isStatic(declaredMethod.getModifiers())) {
                            this.LOGGER.error("Cannot call static render layer method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName());
                            continue;
                        }
                        if (!RenderType.class.isAssignableFrom(declaredMethod.getReturnType())) {
                            this.LOGGER.error("RenderLayer annotated method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName() + " does not return RenderType");
                            continue;
                        }
                        if (declaredMethod.getParameterCount() != 0) {
                            this.LOGGER.error("RenderLayer annotated method " + declaredMethod.getName() + " in " + blockClazz.getSimpleName() + " requires arguments");
                            continue;
                        }
                        if (renderType != null) {
                            this.LOGGER.error("Duplicate RenderLayer methods in " + blockClazz.getSimpleName());
                            continue;
                        }
                        declaredMethod.setAccessible(true);
                        try {
                            Object obj = declaredMethod.invoke((Object)block, new Object[0]);
                            renderType = (RenderType)obj;
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                            continue;
                        }
                        RenderType finalRenderType = renderType;
                        this.clientSetupEvent.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)finalRenderType));
                    }
                }, new Event[0]);
            }
            if (annotation.registerItem()) {
                boolean creativeTabBlock = blockClazz.isAnnotationPresent(CreativeTabBlock.class);
                this.itemRegistrationQueue.enqueue(() -> {
                    BlockItem item = new BlockItem(block, new Item.Properties().m_41491_(annotation.creativeTab() ? this.itemGroup : null));
                    this.itemRegistryEvent.register(new ResourceLocation(registryName), (Object)item);
                    if (creativeTabBlock) {
                        if (this.LOGGER.isDebugEnabled()) {
                            this.LOGGER.debug("Creative tab item set as " + registryName + " for mod " + modNamespace);
                        }
                        this.itemGroupItem = item;
                    }
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("BlockItem registered for " + registryName);
                    }
                }, new Event[0]);
            }
        }, new Event[0]);
    }

    private void registerItemAnnotation(String modNamespace, Class<?> itemClazz, String memberName) {
        if (itemClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Registration of item at " + memberName + " in " + itemClazz.getName() + " ignored");
            }
            return;
        }
        this.itemRegistrationQueue.enqueue(() -> {
            RegisterItem annotation;
            Item item;
            try {
                Field field = itemClazz.getDeclaredField(memberName);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Registration of item at " + memberName + " in " + itemClazz.getName() + " ignored");
                    }
                    return;
                }
                field.setAccessible(true);
                item = (Item)field.get(null);
                annotation = field.getAnnotation(RegisterItem.class);
                if (!Modifier.isFinal(field.getModifiers())) {
                    this.LOGGER.warn("Non-final item instance variable " + memberName + " in " + itemClazz.getSimpleName());
                }
            }
            catch (NoSuchFieldException e) {
                this.LOGGER.error("Unable to find item field for block " + memberName + " in " + itemClazz.getSimpleName());
                return;
            }
            catch (IllegalAccessException e) {
                this.LOGGER.error("Unable to access item field for block " + memberName + " in " + itemClazz.getSimpleName());
                return;
            }
            if (item == null) {
                this.LOGGER.warn("Null item instance variable " + memberName + " in " + itemClazz.getSimpleName());
                return;
            }
            String modid = annotation.modid();
            if (modid.equals("")) {
                modid = modNamespace;
            }
            String name = annotation.name();
            if (modid.equals("")) {
                this.LOGGER.error("Unable to register item " + memberName + " in " + itemClazz.getSimpleName() + " without a registry name");
                return;
            }
            String registryName = modid + ":" + name;
            if (annotation.creativeTab()) {
                try {
                    itemCreativeModeTabField.set(item, this.itemGroup);
                }
                catch (IllegalAccessException e) {
                    this.LOGGER.error("Failed to set item category when registering " + registryName);
                    return;
                }
            }
            this.itemRegistryEvent.register(new ResourceLocation(registryName), (Object)item);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Item registered: " + registryName);
            }
        }, new Event[0]);
    }

    private void registerFluidAnnotation(String modNamespace, Class<?> fluidClazz, String memberName) {
        if (fluidClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Registration of fluid at " + memberName + " in " + fluidClazz.getName() + " ignored");
            }
            return;
        }
        this.blockRegistrationQueue.enqueue(() -> {
            PhosphophylliteFluid flowingInstance;
            PhosphophylliteFluid stillInstance;
            Constructor constructor;
            assert (fluidClazz.isAnnotationPresent(RegisterFluid.class));
            final RegisterFluid annotation = fluidClazz.getAnnotation(RegisterFluid.class);
            final String modid = annotation.modid().equals("") ? modNamespace : annotation.modid();
            final String name = annotation.name();
            if (modid.equals("")) {
                this.LOGGER.error("Unable to register fluid without a name");
                return;
            }
            if (!ForgeFlowingFluid.class.isAssignableFrom(fluidClazz)) {
                this.LOGGER.error("Attempt to register fluid from class not extended from PhosphophylliteFluid");
                return;
            }
            String baseRegistryName = modid + ":" + name;
            ResourceLocation baseResourceLocation = new ResourceLocation(baseRegistryName);
            PhosphophylliteFluid[] fluids = new PhosphophylliteFluid[2];
            Item[] bucketArray = new Item[1];
            LiquidBlock[] blockArray = new LiquidBlock[1];
            try {
                constructor = fluidClazz.getDeclaredConstructor(ForgeFlowingFluid.Properties.class);
            }
            catch (NoSuchMethodException e) {
                this.LOGGER.error("Failed to find constructor to create instance of " + fluidClazz.getSimpleName());
                return;
            }
            Supplier<PhosphophylliteFluid> stillSupplier = () -> fluids[0];
            Supplier<PhosphophylliteFluid> flowingSupplier = () -> fluids[1];
            FluidType fluidType = new FluidType(FluidType.Properties.create()){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){
                        final ResourceLocation stillTexture;
                        final ResourceLocation flowingTexture;
                        final ResourceLocation overlayTexture;
                        {
                            this.stillTexture = new ResourceLocation(modid, "fluid/" + name + "_still");
                            this.flowingTexture = new ResourceLocation(modid, "fluid/" + name + "_flowing");
                            this.overlayTexture = new ResourceLocation(modid, "fluid/" + name + "_overlay");
                        }

                        public ResourceLocation getStillTexture() {
                            return this.stillTexture;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return this.flowingTexture;
                        }

                        public ResourceLocation getOverlayTexture() {
                            return this.overlayTexture;
                        }

                        public int getTintColor() {
                            return annotation.color();
                        }
                    });
                }
            };
            ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(() -> Registry.lambda$registerFluidAnnotation$8(fluidType), stillSupplier, flowingSupplier);
            if (annotation.registerBucket()) {
                properties.bucket(() -> bucketArray[0]);
            }
            properties.block(() -> blockArray[0]);
            try {
                stillInstance = (PhosphophylliteFluid)((Object)((Object)constructor.newInstance(properties)));
                flowingInstance = (PhosphophylliteFluid)((Object)((Object)constructor.newInstance(properties)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                this.LOGGER.error("Exception caught when instantiating instance of " + fluidClazz.getSimpleName());
                e.printStackTrace();
                return;
            }
            stillInstance.isSource = true;
            fluids[0] = stillInstance;
            fluids[1] = flowingInstance;
            blockArray[0] = new LiquidBlock(stillSupplier, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_155956_(100.0f).m_222994_());
            for (Field declaredField : fluidClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterFluid.Instance.class)) continue;
                if (!declaredField.getType().isAssignableFrom(fluidClazz)) {
                    this.LOGGER.error("Unassignable instance variable " + declaredField.getName() + " in " + fluidClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    this.LOGGER.error("Cannot set non-static instance variable " + declaredField.getName() + " in " + fluidClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, (Object)stillInstance);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            this.blockRegistryEvent.register(baseResourceLocation, (Object)blockArray[0]);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("FluidBlock registered: " + baseResourceLocation);
            }
            this.fluidRegistrationQueue.enqueue(() -> {
                PhosphophylliteFluid still = fluids[0];
                PhosphophylliteFluid flowing = fluids[1];
                if (still == null || flowing == null) {
                    return;
                }
                this.fluidRegistryEvent.register(baseResourceLocation, (Object)still);
                this.fluidRegistryEvent.register(new ResourceLocation(baseRegistryName + "_flowing"), (Object)flowing);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Fluid registered: " + baseResourceLocation);
                }
            }, new Event[0]);
            if (annotation.registerBucket()) {
                this.itemRegistrationQueue.enqueue(() -> {
                    BucketItem bucket = new BucketItem(() -> fluids[0], new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(this.itemGroup));
                    bucketArray[0] = bucket;
                    this.itemRegistryEvent.register(new ResourceLocation(baseRegistryName + "_bucket"), (Object)bucket);
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Bucket registered: " + baseResourceLocation);
                    }
                }, new Event[0]);
            }
            this.fluidTypeRegistrationQueue.enqueueUntracked(() -> this.lambda$registerFluidAnnotation$14(baseResourceLocation, fluidType));
        }, new Event[0]);
    }

    private void registerContainerAnnotation(String modNamespace, Class<?> containerClazz, String memberName) {
        if (containerClazz.isAnnotationPresent(IgnoreRegistration.class)) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Registration of container at " + memberName + " in " + containerClazz.getName() + " ignored");
            }
            return;
        }
        assert (containerClazz.isAnnotationPresent(RegisterContainer.class));
        RegisterContainer annotation = containerClazz.getAnnotation(RegisterContainer.class);
        String modid = annotation.modid();
        if (modid.equals("")) {
            modid = modNamespace;
        }
        String name = annotation.name();
        if (modid.equals("")) {
            this.LOGGER.error("Unable to register container without a name");
            return;
        }
        if (!AbstractContainerMenu.class.isAssignableFrom(containerClazz)) {
            this.LOGGER.error("Attempt to register container from class not extended from Container");
            return;
        }
        String registryName = modid + ":" + name;
        MenuType[] containerTypeArray = new MenuType[1];
        this.containerRegistrationQueue.enqueue(() -> {
            ContainerSupplier supplier = null;
            for (Field declaredField : containerClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterContainer.Supplier.class)) continue;
                int modifiers = declaredField.getModifiers();
                if (!Modifier.isStatic(modifiers)) {
                    this.LOGGER.error("Cannot access non-static container supplier " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    return;
                }
                if (!Modifier.isFinal(modifiers)) {
                    this.LOGGER.warn("Container supplier " + declaredField.getName() + " not final in" + containerClazz.getSimpleName());
                }
                if (!ContainerSupplier.class.isAssignableFrom(declaredField.getType())) {
                    this.LOGGER.error("Supplier annotation found on non-ContainerSupplier field " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                if (supplier != null) {
                    this.LOGGER.error("Duplicate suppliers for container " + containerClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    supplier = (ContainerSupplier)declaredField.get(null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                if (supplier != null) continue;
                this.LOGGER.error("Container supplier field " + declaredField.getName() + " null in " + containerClazz.getSimpleName());
            }
            if (supplier == null) {
                this.LOGGER.error("No supplier found for container " + containerClazz.getSimpleName());
                return;
            }
            ContainerSupplier finalSupplier = supplier;
            containerTypeArray[0] = IForgeMenuType.create((windowId, playerInventory, data) -> finalSupplier.create(windowId, data.m_130135_(), playerInventory.f_35978_));
            for (Field declaredField : containerClazz.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(RegisterContainer.Type.class)) continue;
                if (!declaredField.getType().isAssignableFrom(MenuType.class)) {
                    this.LOGGER.error("Unassignable type variable " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                if (!Modifier.isStatic(declaredField.getModifiers())) {
                    this.LOGGER.error("Cannot set non-static type variable " + declaredField.getName() + " in " + containerClazz.getSimpleName());
                    continue;
                }
                declaredField.setAccessible(true);
                try {
                    declaredField.set(null, containerTypeArray[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            MenuType type = containerTypeArray[0];
            if (type == null) {
                return;
            }
            this.containerRegistryEvent.register(new ResourceLocation(registryName), (Object)type);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Container registered: " + registryName);
            }
        }, new Event[0]);
    }

    private void registerTileAnnotation(String modNamespace, Class<?> declaringClass, String memberName) {
        if (declaringClass.isAnnotationPresent(IgnoreRegistration.class)) {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Registration of tile at " + memberName + " in " + declaringClass.getName() + " ignored");
            }
            return;
        }
        this.tileRegistrationQueue.enqueue(() -> {
            RegisterTile.Producer producer;
            RegisterTile annotation;
            Field field;
            try {
                field = declaringClass.getDeclaredField(memberName);
                if (!field.isAnnotationPresent(RegisterTile.class)) {
                    this.LOGGER.error("Schrodinger's annotation on field " + memberName + " in " + declaringClass.getSimpleName());
                    return;
                }
                annotation = field.getAnnotation(RegisterTile.class);
                if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                    if (this.LOGGER.isDebugEnabled()) {
                        this.LOGGER.debug("Registration of tile at " + memberName + " in " + declaringClass.getName() + " ignored");
                    }
                    return;
                }
                field.setAccessible(true);
                Object producerObject = field.get(null);
                if (producerObject == null) {
                    this.LOGGER.error("Null supplier for tile field " + memberName + " in " + declaringClass.getSimpleName());
                    return;
                }
                if (producerObject.getClass() != RegisterTile.Producer.class) {
                    this.LOGGER.error("Attempt to register non-TileProducer BlockEntitySupplier " + memberName + " in " + declaringClass.getSimpleName());
                    return;
                }
                producer = (RegisterTile.Producer)producerObject;
            }
            catch (NoSuchFieldException e) {
                this.LOGGER.error("Unable to find supplier field for tile " + memberName + " in " + declaringClass.getSimpleName());
                return;
            }
            catch (IllegalAccessException e) {
                this.LOGGER.error("Unable to access supplier field for tile " + memberName + " in " + declaringClass.getSimpleName());
                return;
            }
            String modid = annotation.modid();
            if (modid.equals("")) {
                modid = modNamespace;
            }
            String name = annotation.value();
            if (modid.equals("")) {
                this.LOGGER.error("Unable to register tile without a name from " + memberName + " in " + declaringClass.getSimpleName());
                return;
            }
            String registryName = modid + ":" + name;
            Class tileClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            LinkedList<Block> blocks = this.tileBlocks.remove(tileClass);
            if (blocks == null) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("TileEntity has no blocks, ignoring registration: " + registryName);
                }
                return;
            }
            BlockEntityType type = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)producer, (Block[])blocks.toArray(new Block[blocks.size()])).m_58966_(null);
            try {
                tileProducerTYPEField.set(producer, type);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Tile entity type unable to be saved for " + memberName + " in " + declaringClass.getSimpleName());
            }
            this.tileRegistryEvent.register(new ResourceLocation(registryName), (Object)type);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("TileEntity registered: " + registryName);
            }
        }, new Event[0]);
    }

    private void registerCapabilityAnnotation(String modNamespace, Class<?> declaringClass, String memberName) {
        try {
            Field field = declaringClass.getDeclaredField(memberName);
            Class capabilityClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            this.registerCapabilityQueue.enqueueUntracked(() -> {
                this.registerCapabilitiesEvent.register(capabilityClass);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Capability registered: " + capabilityClass.getName());
                }
            });
        }
        catch (NoSuchFieldException e) {
            this.LOGGER.error("Failed to register capability field " + memberName + " in " + declaringClass.getSimpleName());
        }
    }

    private void registerConfigAnnotation(String modNamespace, Class<?> configClazz, String memberName) {
        try {
            Field field = configClazz.getDeclaredField(memberName);
            if (field.isAnnotationPresent(IgnoreRegistration.class)) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Registration of config at " + memberName + " in " + configClazz.getName() + " ignored");
                }
                return;
            }
            Object configObject = field.get(null);
            RegisterConfig annotation = field.getAnnotation(RegisterConfig.class);
            ConfigManager.registerConfig(configObject, annotation);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Config registered: " + annotation.name() + " for " + modNamespace);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void onModLoadAnnotation(String modNamespace, Class<?> modLoadClazz, String memberName) {
        try {
            Method method = modLoadClazz.getDeclaredMethod(memberName.substring(0, memberName.indexOf(40)), new Class[0]);
            if (method.isAnnotationPresent(IgnoreRegistration.class)) {
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("Running of @OnModLoad for " + memberName + " in " + modLoadClazz.getName() + " ignored");
                }
                return;
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                this.LOGGER.error("Cannot call non-static @OnModLoad method " + method.getName() + " in " + modLoadClazz.getSimpleName());
                return;
            }
            if (method.getParameterCount() != 0) {
                this.LOGGER.error("Cannot call @OnModLoad method with parameters " + method.getName() + " in " + modLoadClazz.getSimpleName());
                return;
            }
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("@OnModLoad for " + memberName + " in " + modLoadClazz.getName() + " run");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            this.LOGGER.warn(modLoadClazz.getName());
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$registerFluidAnnotation$14(ResourceLocation baseResourceLocation, 2 fluidType) {
        this.fluidTypeRegistryEvent.register(baseResourceLocation, (Object)fluidType);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("FluidType registered: " + baseResourceLocation);
        }
    }

    private static /* synthetic */ FluidType lambda$registerFluidAnnotation$8(2 fluidType) {
        return fluidType;
    }

    static {
        Field itemField = null;
        for (Field declaredField : Item.class.getDeclaredFields()) {
            if (!declaredField.getType().equals(CreativeModeTab.class)) continue;
            itemField = declaredField;
        }
        if (itemField == null) {
            throw new IllegalStateException("Unable to find category field in Item.class");
        }
        itemField.setAccessible(true);
        itemCreativeModeTabField = itemField;
        try {
            tileProducerTYPEField = RegisterTile.Producer.class.getDeclaredField("TYPE");
            tileProducerTYPEField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    private static interface AnnotationHandler {
        public void run(String var1, Class<?> var2, String var3);
    }
}

