/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.ClientRegistryImpl;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.common.block.entity.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;

public class AssemblyPlatformRenderer
extends AbstractBlockEntityModelRenderer<AssemblyPlatformBlockEntity> {
    private static final float ITEM_SCALE = 0.5f;
    private final ModelPart claw1;
    private final ModelPart claw2;
    private static final String CLAW1 = "claw1";
    private static final String CLAW2 = "claw2";

    public AssemblyPlatformRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.ASSEMBLY_PLATFORM);
        this.claw1 = root.m_171324_(CLAW1);
        this.claw2 = root.m_171324_(CLAW2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(CLAW1, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("claw1_0", -0.5f, 0.0f, 0.1f, 3, 1, 1, new CubeDeformation(-0.1f), 0, 12).m_171534_("claw1_1", -0.5f, 0.0f, 0.6f, 3, 1, 1, 8, 14).m_171480_(), PartPose.m_171419_((float)-1.0f, (float)17.0f, (float)0.0f));
        partdefinition.m_171599_(CLAW2, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("claw2_0", -0.5f, 0.0f, -0.1f, 3, 1, 1, new CubeDeformation(-0.1f), 0, 14).m_171534_("claw2_1", -0.5f, 0.0f, -0.6f, 3, 1, 1, 8, 12).m_171480_(), PartPose.m_171419_((float)-1.0f, (float)17.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    public void renderModel(AssemblyPlatformBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IAssemblyRenderOverriding renderOverride;
        ItemStack heldStack = te.getPrimaryInventory().getStackInSlot(0);
        Pair<IAssemblyRenderOverriding, Float> clawTranslation = this.getClawTranslation(Mth.m_14179_((float)partialTicks, (float)te.oldClawProgress, (float)te.clawProgress), heldStack);
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)Textures.MODEL_ASSEMBLY_PLATFORM));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 0.0, (double)((Float)clawTranslation.getRight()).floatValue());
        this.claw1.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85837_(0.0, 0.0, (double)(-2.0f * ((Float)clawTranslation.getRight()).floatValue()));
        this.claw2.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
        if (!heldStack.m_41619_() && ((renderOverride = (IAssemblyRenderOverriding)clawTranslation.getLeft()) == null || renderOverride.applyRenderChangePlatform(matrixStackIn, heldStack))) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            double yOffset = heldStack.m_41720_() instanceof BlockItem ? -1.03125 : -1.09375;
            matrixStackIn.m_85837_(0.0, yOffset + 0.05, 0.0);
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedModel = itemRenderer.m_174264_(heldStack, te.m_58904_(), null, 0);
            itemRenderer.m_115143_(heldStack, ItemTransforms.TransformType.FIXED, true, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, bakedModel);
        }
    }

    private Pair<IAssemblyRenderOverriding, Float> getClawTranslation(float clawProgress, ItemStack heldStack) {
        IAssemblyRenderOverriding renderOverride = ClientRegistryImpl.getInstance().getAssemblyRenderOverride((ItemLike)heldStack.m_41720_());
        float clawTrans = !heldStack.m_41619_() ? (renderOverride != null ? renderOverride.getPlatformClawShift(heldStack) : (heldStack.m_41720_() instanceof BlockItem ? 0.09375f - clawProgress * 0.1f / 16.0f : 0.09375f - clawProgress * 1.4f / 16.0f)) : 0.09375f - clawProgress * 1.5f / 16.0f;
        return Pair.of((Object)renderOverride, (Object)Float.valueOf(clawTrans));
    }
}

