/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class RenderNavigator {
    private final BlockPos targetPos;
    private Path path;
    private boolean increaseAlpha;
    private float alphaValue = 0.2f;

    public RenderNavigator(BlockPos targetPos) {
        this.targetPos = targetPos;
        this.updatePath();
    }

    public void updatePath() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Mob e = PneumaticCraftUtils.createDummyEntity((Player)player);
        e.m_6853_(player.m_20096_());
        this.path = e.m_21573_().m_7864_(this.targetPos, 1);
        if (!this.tracedToDestination()) {
            this.path = CoordTrackClientHandler.getDronePath((Player)player, this.targetPos);
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, boolean wirePath, boolean xRayEnabled, float partialTicks) {
        if (this.path == null) {
            return;
        }
        boolean hasDestinationPath = this.tracedToDestination();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.01, 0.0);
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        if (wirePath) {
            VertexConsumer builder = buffer.m_6299_(ModRenderTypes.getLineLoops(5.0));
            Matrix3f normal = matrixStack.m_85850_().m_85864_();
            for (int i = 1; i < this.path.m_77398_(); ++i) {
                float red = 1.0f;
                if (this.path.m_77398_() - i < 200) {
                    red = (float)(this.path.m_77398_() - i) * 0.005f;
                }
                Node lastPoint = this.path.m_77375_(i - 1);
                Node pathPoint = this.path.m_77375_(i);
                builder.m_85982_(posMat, (float)lastPoint.f_77271_ + 0.5f, (float)lastPoint.f_77272_, (float)lastPoint.f_77273_ + 0.5f).m_85950_(red, 1.0f - red, 0.0f, 0.5f).m_85977_(normal, (float)(pathPoint.f_77271_ - lastPoint.f_77271_), (float)(pathPoint.f_77272_ - lastPoint.f_77272_), (float)(pathPoint.f_77273_ - lastPoint.f_77273_)).m_5752_();
                builder.m_85982_(posMat, (float)(lastPoint.f_77271_ + pathPoint.f_77271_) / 2.0f + 0.5f, (float)Math.max(lastPoint.f_77272_, pathPoint.f_77272_), (float)(lastPoint.f_77273_ + pathPoint.f_77273_) / 2.0f + 0.5f).m_85950_(red, 1.0f - red, 0.0f, 0.5f).m_85977_(normal, (float)(pathPoint.f_77271_ - lastPoint.f_77271_), (float)(pathPoint.f_77272_ - lastPoint.f_77272_), (float)(pathPoint.f_77273_ - lastPoint.f_77273_)).m_5752_();
                builder.m_85982_(posMat, (float)pathPoint.f_77271_ + 0.5f, (float)pathPoint.f_77272_, (float)pathPoint.f_77273_ + 0.5f).m_85950_(red, 1.0f - red, 0.0f, 0.5f).m_85977_(normal, (float)(pathPoint.f_77271_ - lastPoint.f_77271_), (float)(pathPoint.f_77272_ - lastPoint.f_77272_), (float)(pathPoint.f_77273_ - lastPoint.f_77273_)).m_5752_();
            }
        } else {
            VertexConsumer builder = buffer.m_6299_(xRayEnabled ? ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH : ModRenderTypes.UNTEXTURED_QUAD);
            if (hasDestinationPath) {
                if (this.alphaValue > 0.2f) {
                    this.alphaValue -= 0.005f;
                }
            } else if (this.increaseAlpha) {
                this.alphaValue += 0.005f;
                if (this.alphaValue > 0.3f) {
                    this.increaseAlpha = false;
                }
            } else {
                this.alphaValue -= 0.005f;
                if (this.alphaValue < 0.2f) {
                    this.increaseAlpha = true;
                }
            }
            for (int i = 0; i < this.path.m_77398_(); ++i) {
                float red = 1.0f;
                if (this.path.m_77398_() - i < 200) {
                    red = (float)(this.path.m_77398_() - i) * 0.005f;
                }
                Node pathPoint = this.path.m_77375_(i);
                builder.m_85982_(posMat, (float)pathPoint.f_77271_, (float)pathPoint.f_77272_, (float)pathPoint.f_77273_).m_85950_(red, 1.0f - red, 0.0f, this.alphaValue).m_85969_(0xF000F0).m_5752_();
                builder.m_85982_(posMat, (float)pathPoint.f_77271_, (float)pathPoint.f_77272_, (float)(pathPoint.f_77273_ + 1)).m_85950_(red, 1.0f - red, 0.0f, this.alphaValue).m_85969_(0xF000F0).m_5752_();
                builder.m_85982_(posMat, (float)(pathPoint.f_77271_ + 1), (float)pathPoint.f_77272_, (float)(pathPoint.f_77273_ + 1)).m_85950_(red, 1.0f - red, 0.0f, this.alphaValue).m_85969_(0xF000F0).m_5752_();
                builder.m_85982_(posMat, (float)(pathPoint.f_77271_ + 1), (float)pathPoint.f_77272_, (float)pathPoint.f_77273_).m_85950_(red, 1.0f - red, 0.0f, this.alphaValue).m_85969_(0xF000F0).m_5752_();
            }
        }
        matrixStack.m_85849_();
    }

    public boolean tracedToDestination() {
        if (this.path == null) {
            return false;
        }
        Node finalPoint = this.path.m_77395_();
        return finalPoint != null && this.targetPos.equals((Object)new BlockPos(finalPoint.f_77271_, finalPoint.f_77272_, finalPoint.f_77273_));
    }
}

