/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.theoneprobe;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IInfoForwarder;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.item.CamoApplicatorItem;
import me.desht.pneumaticcraft.common.thirdparty.theoneprobe.ElementPressure;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TOPInfoProvider {
    private static final ChatFormatting COLOR = ChatFormatting.GRAY;

    static void handleBlock(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, IProbeHitData data) {
        BlockEntity te = world.m_7702_(data.getPos());
        if (te instanceof IInfoForwarder) {
            IInfoForwarder f = (IInfoForwarder)te;
            te = f.getInfoBlockEntity();
        }
        if (te == null) {
            return;
        }
        if (te.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).isPresent()) {
            TOPInfoProvider.handlePneumatic(mode, probeInfo, te, data);
        }
        if (te.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
            TOPInfoProvider.handleHeat(mode, probeInfo, te);
        }
        if (((Boolean)ConfigHelper.client().general.topShowsFluids.get()).booleanValue()) {
            te.getCapability(ForgeCapabilities.FLUID_HANDLER, data.getSideHit()).ifPresent(handler -> TOPInfoProvider.handleFluidTanks(mode, probeInfo, handler));
        }
        if (te instanceof IRedstoneControl) {
            TOPInfoProvider.handleRedstoneMode(mode, probeInfo, (IRedstoneControl)te);
        }
        if (te instanceof PressureTubeBlockEntity) {
            TOPInfoProvider.handlePressureTube(mode, probeInfo, (PressureTubeBlockEntity)te, data.getSideHit(), player);
        }
        if (te instanceof CamouflageableBlockEntity) {
            TOPInfoProvider.handleCamo(mode, probeInfo, ((CamouflageableBlockEntity)te).getCamouflage());
        }
    }

    static void handleSemiblock(Player player, ProbeMode mode, IProbeInfo probeInfo, ISemiBlock semiBlock) {
        IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(semiBlock.getColor())));
        IProbeInfo horiz = vert.horizontal();
        NonNullList<ItemStack> drops = semiBlock.getDrops();
        if (!drops.isEmpty()) {
            ItemStack stack = (ItemStack)drops.get(0);
            horiz.item(stack);
            horiz.text(stack.m_41786_());
            semiBlock.addTooltip(arg_0 -> ((IProbeInfo)vert).text(arg_0), player, stack.m_41783_(), player.m_6144_());
        }
    }

    private static void handlePneumatic(ProbeMode mode, IProbeInfo probeInfo, BlockEntity pneumaticMachine, IProbeHitData data) {
        LinkedHashSet set = new LinkedHashSet();
        pneumaticMachine.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(set::add);
        for (Direction d : DirectionUtil.VALUES) {
            pneumaticMachine.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, d).ifPresent(set::add);
        }
        for (IAirHandlerMachine h : set) {
            TOPInfoProvider.addPressureInfo(mode, probeInfo, pneumaticMachine, h);
        }
    }

    private static void addPressureInfo(ProbeMode mode, IProbeInfo probeInfo, BlockEntity pneumaticMachine, IAirHandlerMachine airHandler) {
        String pressure = PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 2);
        String dangerPressure = PneumaticCraftUtils.roundNumberTo(airHandler.getDangerPressure(), 2);
        probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressureMax", pressure, dangerPressure).m_130940_(COLOR));
        if (mode == ProbeMode.EXTENDED) {
            probeInfo.horizontal().element((IElement)new ElementPressure(pneumaticMachine, airHandler)).vertical().text((Component)Component.m_237119_()).text((Component)Component.m_237113_((String)(" \u2b05 " + pressure + " bar")));
        }
    }

    private static void handleHeat(ProbeMode mode, IProbeInfo probeInfo, BlockEntity heatExchanger) {
        TemperatureData tempData = new TemperatureData((ICapabilityProvider)heatExchanger);
        if (tempData.isMultisided()) {
            for (Direction face : DirectionUtil.VALUES) {
                if (!tempData.hasData(face)) continue;
                probeInfo.text(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
            }
        } else if (tempData.hasData(null)) {
            probeInfo.text(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
        }
    }

    private static void handleRedstoneMode(ProbeMode mode, IProbeInfo probeInfo, IRedstoneControl<?> redstoneControl) {
        probeInfo.text(redstoneControl.getRedstoneController().getDescription());
    }

    private static void handlePressureTube(ProbeMode mode, IProbeInfo probeInfo, PressureTubeBlockEntity te, Direction face, Player player) {
        AbstractTubeModule module = PressureTubeBlock.getFocusedModule(te.nonNullLevel(), te.m_58899_(), player);
        if (module != null) {
            ArrayList<Component> currenttip = new ArrayList<Component>();
            module.addInfo(currenttip);
            if (!currenttip.isEmpty()) {
                IProbeInfo vert = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-12566273)));
                currenttip.forEach(arg_0 -> ((IProbeInfo)vert).text(arg_0));
            }
        }
    }

    static void handleFluidTanks(ProbeMode mode, IProbeInfo probeInfo, IFluidHandler handler) {
        if (mode == ProbeMode.EXTENDED) {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack fluidStack = handler.getFluidInTank(i);
                MutableComponent fluidDesc = fluidStack.isEmpty() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]) : Component.m_237113_((String)(fluidStack.getAmount() + "mB ")).m_7220_((Component)PneumaticCraftUtils.xlate(fluidStack.getTranslationKey(), new Object[0]));
                probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tank", i + 1, fluidDesc.m_6881_().m_130940_(ChatFormatting.AQUA)));
            }
        }
    }

    private static void handleCamo(ProbeMode mode, IProbeInfo probeInfo, BlockState camo) {
        if (camo != null) {
            probeInfo.text((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.camo", CamoApplicatorItem.getCamoStateDisplayName(camo)));
        }
    }
}

