/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;

public final class CombModel
implements IUnbakedGeometry<CombModel> {
    public static final CombModel INSTANCE = new CombModel((ImmutableList<Material>)ImmutableList.of());
    public ImmutableList<Material> textures;
    public final ImmutableSet<Integer> fullBrightLayers;

    public CombModel(ImmutableList<Material> textures) {
        this(textures, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public CombModel(@Nullable ImmutableList<Material> textures, ImmutableSet<Integer> fullBrightLayers) {
        this.textures = textures;
        this.fullBrightLayers = fullBrightLayers;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (Material)this.textures.get(0));
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particle, (ItemOverrides)new Overrides(this, overrides, modelTransform, context, spriteGetter), (ItemTransforms)context.getTransforms());
        return builder.build();
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (owner.hasMaterial("layer" + i)) {
            Material mat = owner.getMaterial("layer" + i);
            builder.add((Object)mat);
            ++i;
        }
        this.textures = builder.build();
        return this.textures;
    }

    private static RenderTypeGroup renderType(boolean isFullbright) {
        return new RenderTypeGroup(RenderType.m_110466_(), isFullbright ? ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    }

    public static class Overrides
    extends ItemOverrides {
        private final Map<String, BakedModel> modelCache = Maps.newHashMap();
        private final CombModel combModel;
        private final ItemOverrides nested;
        private final ModelState modelState;
        private final IGeometryBakingContext context;
        private final Function<Material, TextureAtlasSprite> spriteGetter;

        private Overrides(CombModel combModel, ItemOverrides nested, ModelState modelState, IGeometryBakingContext context, Function<Material, TextureAtlasSprite> spriteGetter) {
            this.combModel = combModel;
            this.nested = nested;
            this.modelState = modelState;
            this.context = context;
            this.spriteGetter = spriteGetter;
        }

        @Nullable
        public BakedModel m_173464_(@Nonnull BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int seed) {
            CompoundTag tag = stack.m_41737_("EntityTag");
            if (tag != null && tag.m_128441_("type")) {
                String beeType = tag.m_128461_("type");
                if (!this.modelCache.containsKey(beeType)) {
                    CompoundTag nbt = BeeReloadListener.INSTANCE.getData(beeType);
                    if (nbt == null) {
                        this.modelCache.put(beeType, model);
                    } else {
                        TextureAtlasSprite sprite;
                        if (nbt.m_128441_("combTexture")) {
                            Material texture = new Material(InventoryMenu.f_39692_, new ResourceLocation(nbt.m_128461_("combTexture")));
                            sprite = this.spriteGetter.apply(texture);
                        } else {
                            sprite = this.spriteGetter.apply((Material)this.combModel.textures.get(0));
                        }
                        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)this.context, (TextureAtlasSprite)sprite, (ItemOverrides)this.nested, (ItemTransforms)this.context.getTransforms());
                        boolean fullBright = this.combModel.fullBrightLayers.contains((Object)0);
                        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite);
                        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)this.modelState, (ResourceLocation)new ResourceLocation("productivebees", "base"));
                        builder.addQuads(CombModel.renderType(fullBright), (Collection)quads);
                        if (nbt.m_128441_("renderer") && nbt.m_128461_("renderer").equals("default_crystal")) {
                            TextureAtlasSprite crystalSprite = this.spriteGetter.apply((Material)this.combModel.textures.get(1));
                            fullBright = this.combModel.fullBrightLayers.contains((Object)1);
                            unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)crystalSprite);
                            quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> crystalSprite, (ModelState)this.modelState, (ResourceLocation)new ResourceLocation("productivebees", "crystal"));
                            builder.addQuads(CombModel.renderType(fullBright), (Collection)quads);
                        }
                        this.modelCache.put(beeType, builder.build());
                    }
                }
                return this.modelCache.getOrDefault(beeType, model);
            }
            return model;
        }
    }

    public static class Loader
    implements IGeometryLoader<CombModel> {
        public static final Loader INSTANCE = new Loader();

        @Nonnull
        public CombModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            ImmutableSet.Builder fullbrightLayers = ImmutableSet.builder();
            if (jsonObject.has("fullbright_layers")) {
                JsonArray arr = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"fullbright_layers");
                for (int i = 0; i < arr.size(); ++i) {
                    fullbrightLayers.add((Object)arr.get(i).getAsInt());
                }
            }
            return new CombModel(null, (ImmutableSet<Integer>)fullbrightLayers.build());
        }
    }
}

