/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.StoneChip;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class StoneChipRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final Integer count;

    public StoneChipRecipe(ResourceLocation id, Integer count) {
        this.id = id;
        this.count = count;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Block chipBlock = null;
        int matchingStacks = 0;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            if (chipBlock == null && itemstack.m_41720_().equals(ModItems.STONE_CHIP.get())) {
                chipBlock = StoneChip.getBlock(itemstack);
            }
            if (itemstack.m_41720_().equals(ModItems.STONE_CHIP.get()) && StoneChip.getBlock(itemstack).equals(chipBlock)) {
                ++matchingStacks;
                continue;
            }
            return false;
        }
        return matchingStacks == this.count;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        ItemStack stack = inv.m_8020_(0);
        return new ItemStack((ItemLike)StoneChip.getBlock(stack));
    }

    public boolean m_8004_(int width, int height) {
        int min = this.count > 4 ? 3 : 2;
        return width >= min && height >= min;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)Items.f_41905_);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        for (int i = 0; i < this.count; ++i) {
            list.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{StoneChip.getStack(Blocks.f_50069_)}));
        }
        return list;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.STONE_CHIP.get();
    }

    public static class Serializer<T extends StoneChipRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Integer count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)9);
            return this.factory.create(id, count);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading stone chip recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.writeInt(((StoneChipRecipe)recipe).count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing stone chip recipe to packet. " + ((StoneChipRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends StoneChipRecipe> {
            public T create(ResourceLocation var1, Integer var2);
        }
    }
}

