/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.gen.feature.DecoratedHugeFungusConfiguration;
import cy.jdkdigital.productivebees.gen.feature.NetherBeehiveDecorator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.WeepingVinesFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.material.Material;

public class DecoratedHugeFungusFeature
extends Feature<DecoratedHugeFungusConfiguration> {
    public DecoratedHugeFungusFeature(Codec<DecoratedHugeFungusConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<DecoratedHugeFungusConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        RandomSource random = pContext.m_225041_();
        ChunkGenerator chunkgenerator = pContext.m_159775_();
        DecoratedHugeFungusConfiguration configuration = (DecoratedHugeFungusConfiguration)pContext.m_159778_();
        Block block = configuration.f_65897_.m_60734_();
        BlockState blockstate = worldgenlevel.m_8055_(blockpos.m_7495_());
        if (blockstate.m_60713_(block)) {
            int i = Mth.m_216271_((RandomSource)random, (int)4, (int)13);
            if (random.m_188503_(12) == 0) {
                i *= 2;
            }
            if (!configuration.f_65901_) {
                int j = chunkgenerator.m_6331_();
                if (blockpos.m_123342_() + i + 1 >= j) {
                    return false;
                }
            }
            boolean flag = !configuration.f_65901_ && random.m_188501_() < 0.06f;
            worldgenlevel.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 4);
            HashSet logPositions = Sets.newHashSet();
            HashSet leafPositions = Sets.newHashSet();
            this.placeStem((LevelAccessor)worldgenlevel, random, configuration, blockpos, i, flag, logPositions);
            this.placeHat((LevelAccessor)worldgenlevel, random, configuration, blockpos, i, flag, leafPositions);
            if (!configuration.decorators.isEmpty()) {
                BiConsumer<BlockPos, BlockState> biconsumer = (pos, state) -> worldgenlevel.m_7731_(pos, state, 19);
                configuration.decorators.forEach(decorator -> {
                    if (decorator instanceof NetherBeehiveDecorator) {
                        ((NetherBeehiveDecorator)((Object)decorator)).setNest(configuration.nestState);
                    }
                    TreeDecorator.Context context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer, random, logPositions, leafPositions, (Set)Sets.newHashSet());
                    decorator.m_214187_(context);
                });
            }
            return true;
        }
        return false;
    }

    private static boolean isReplaceable(LevelAccessor level, BlockPos pos, boolean replacePlant) {
        return level.m_7433_(pos, state -> {
            Material material = state.m_60767_();
            return state.m_60767_().m_76336_() || replacePlant && material == Material.f_76300_;
        });
    }

    private void placeStem(LevelAccessor level, RandomSource random, HugeFungusConfiguration config, BlockPos pos, int n, boolean planted, Set<BlockPos> logPositions) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockState blockstate = config.f_65898_;
        int i = planted ? 1 : 0;
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                boolean flag = planted && Mth.m_14040_((int)j) == i && Mth.m_14040_((int)k) == i;
                for (int l = 0; l < n; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)pos, j, l, k);
                    if (!DecoratedHugeFungusFeature.isReplaceable(level, (BlockPos)blockpos$mutableblockpos, true)) continue;
                    if (config.f_65901_) {
                        if (!level.m_8055_(blockpos$mutableblockpos.m_7495_()).m_60795_()) {
                            level.m_46961_((BlockPos)blockpos$mutableblockpos, true);
                        }
                        level.m_7731_((BlockPos)blockpos$mutableblockpos, blockstate, 3);
                    } else if (flag) {
                        if (random.m_188501_() < 0.1f) {
                            this.m_5974_((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, blockstate);
                        }
                    } else {
                        this.m_5974_((LevelWriter)level, (BlockPos)blockpos$mutableblockpos, blockstate);
                    }
                    logPositions.add(new BlockPos((Vec3i)blockpos$mutableblockpos));
                }
            }
        }
    }

    private void placeHat(LevelAccessor level, RandomSource random, HugeFungusConfiguration config, BlockPos pos, int n, boolean planted, Set<BlockPos> leavesPositions) {
        int j;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        boolean flag = config.f_65899_.m_60713_(Blocks.f_50451_);
        int i = Math.min(random.m_188503_(1 + n / 3) + 5, n);
        for (int k = j = n - i; k <= n; ++k) {
            int l;
            int n2 = l = k < n - random.m_188503_(3) ? 2 : 1;
            if (i > 8 && k < j + 4) {
                l = 3;
            }
            if (planted) {
                ++l;
            }
            for (int i1 = -l; i1 <= l; ++i1) {
                for (int j1 = -l; j1 <= l; ++j1) {
                    boolean flag1 = i1 == -l || i1 == l;
                    boolean flag2 = j1 == -l || j1 == l;
                    boolean flag3 = !flag1 && !flag2 && k != n;
                    boolean flag4 = flag1 && flag2;
                    boolean flag5 = k < j + 3;
                    blockpos$mutableblockpos.m_122154_((Vec3i)pos, i1, k, j1);
                    if (!DecoratedHugeFungusFeature.isReplaceable(level, (BlockPos)blockpos$mutableblockpos, false)) continue;
                    if (config.f_65901_ && !level.m_8055_(blockpos$mutableblockpos.m_7495_()).m_60795_()) {
                        level.m_46961_((BlockPos)blockpos$mutableblockpos, true);
                    }
                    if (flag5) {
                        if (!flag3) {
                            this.placeHatDropBlock(level, random, (BlockPos)blockpos$mutableblockpos, config.f_65899_, flag);
                        }
                    } else if (flag3) {
                        this.placeHatBlock(level, random, config, blockpos$mutableblockpos, 0.1f, 0.2f, flag ? 0.1f : 0.0f);
                    } else if (flag4) {
                        this.placeHatBlock(level, random, config, blockpos$mutableblockpos, 0.01f, 0.7f, flag ? 0.083f : 0.0f);
                    } else {
                        this.placeHatBlock(level, random, config, blockpos$mutableblockpos, 5.0E-4f, 0.98f, flag ? 0.07f : 0.0f);
                    }
                    leavesPositions.add(new BlockPos((Vec3i)blockpos$mutableblockpos));
                }
            }
        }
    }

    private void placeHatBlock(LevelAccessor level, RandomSource random, HugeFungusConfiguration config, BlockPos.MutableBlockPos pos, float decorChance, float hatChance, float vieChance) {
        if (random.m_188501_() < decorChance) {
            this.m_5974_((LevelWriter)level, (BlockPos)pos, config.f_65900_);
        } else if (random.m_188501_() < hatChance) {
            this.m_5974_((LevelWriter)level, (BlockPos)pos, config.f_65899_);
            if (random.m_188501_() < vieChance) {
                DecoratedHugeFungusFeature.tryPlaceWeepingVines((BlockPos)pos, level, random);
            }
        }
    }

    private void placeHatDropBlock(LevelAccessor level, RandomSource random, BlockPos pos, BlockState state, boolean placeVines) {
        if (level.m_8055_(pos.m_7495_()).m_60713_(state.m_60734_())) {
            this.m_5974_((LevelWriter)level, pos, state);
        } else if ((double)random.m_188501_() < 0.15) {
            this.m_5974_((LevelWriter)level, pos, state);
            if (placeVines && random.m_188503_(11) == 0) {
                DecoratedHugeFungusFeature.tryPlaceWeepingVines(pos, level, random);
            }
        }
    }

    private static void tryPlaceWeepingVines(BlockPos pos, LevelAccessor level, RandomSource random) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_().m_122173_(Direction.DOWN);
        if (level.m_46859_((BlockPos)blockpos$mutableblockpos)) {
            int i = Mth.m_216271_((RandomSource)random, (int)1, (int)5);
            if (random.m_188503_(7) == 0) {
                i *= 2;
            }
            WeepingVinesFeature.m_225352_((LevelAccessor)level, (RandomSource)random, (BlockPos.MutableBlockPos)blockpos$mutableblockpos, (int)i, (int)23, (int)25);
        }
    }
}

